/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Arrays
extends SimpleProcProvider {
    public Arrays() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "array_", "anyarray_");
    }

    public static int getDimensions(Class<?> type, Type elementType) {
        if (type.isArray() && type != elementType.getBinaryCodec().getEncoder().getInputType()) {
            return 1 + Arrays.getDimensions(type.getComponentType(), elementType);
        }
        return 0;
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Object[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.append("");
                return;
            }
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            this.writeArray(buffer, elementType.getDelimeter(), elementType, val, context);
        }

        void writeArray(StringBuilder out, char delim, Type type, Object val, Context context) throws IOException {
            TextEncoder encoder = (TextEncoder)type.getCodec(ResultField.Format.Text).getEncoder();
            out.append('{');
            int len = Array.getLength(val);
            for (int c = 0; c < len; ++c) {
                Object elemVal = Array.get(val, c);
                StringBuilder elemOut = new StringBuilder();
                if (elemVal == null) {
                    out.append("NULL");
                } else if (elemVal.getClass().isArray() && elemVal.getClass() != byte[].class) {
                    this.writeArray(out, delim, type, elemVal, context);
                } else {
                    encoder.encode(type, elemOut, elemVal, context);
                    String elemStr = elemOut.toString();
                    if (TxtEncoder.needsQuotes(elemStr, delim)) {
                        elemStr = elemStr.replace("\\", "\\\\");
                        elemStr = elemStr.replace("\"", "\\\"");
                        out.append('\"').append(elemStr).append('\"');
                    } else {
                        out.append(elemStr);
                    }
                }
                if (c >= len - 1) continue;
                out.append(delim);
            }
            out.append('}');
        }

        private static boolean needsQuotes(String elemStr, char delim) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != delim && ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public Class<?> getOutputType() {
            return Object[].class;
        }

        @Override
        public Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            int length = buffer.length();
            Object[] instance = null;
            if (length != 0) {
                ArrayType atype = (ArrayType)type;
                ArrayList<Object> elements = new ArrayList<Object>();
                this.readArray(buffer, 0, atype.getDelimeter(), type.unwrap(), context, elements);
                instance = elements.toArray();
            }
            return instance;
        }

        int readArray(CharSequence data, int start, char delim, Type type, Context context, List<Object> elements) throws IOException {
            int c;
            if (data.equals("{}")) {
                return start + 1;
            }
            StringBuilder elementTxt = null;
            int len = data.length();
            block5: for (c = start + 1; c < len; ++c) {
                char ch = data.charAt(c);
                switch (ch) {
                    case '{': {
                        ArrayList<Object> subElements = new ArrayList<Object>();
                        c = this.readArray(data, c, delim, type, context, subElements);
                        elements.add(subElements.toArray());
                        continue block5;
                    }
                    case '}': {
                        if (elementTxt == null) break block5;
                        elements.add(this.decode(elementTxt.toString(), type, context));
                        break block5;
                    }
                    case '\"': {
                        elementTxt = elementTxt != null ? elementTxt : new StringBuilder();
                        c = this.readString(data, c, elementTxt);
                        continue block5;
                    }
                    default: {
                        if (Character.isWhitespace(ch)) {
                            c = this.skipWhitespace(data, c);
                            continue block5;
                        }
                        if (ch == delim) {
                            if (elementTxt != null) {
                                elements.add(this.decode(elementTxt.toString(), type, context));
                            }
                            elementTxt = null;
                            continue block5;
                        }
                        elementTxt = elementTxt != null ? elementTxt : new StringBuilder();
                        elementTxt.append(ch);
                    }
                }
            }
            return c;
        }

        int skipWhitespace(CharSequence data, int start) {
            int c;
            int len = data.length();
            for (c = start; c < len && Character.isWhitespace(data.charAt(c)); ++c) {
            }
            return c;
        }

        int readString(CharSequence data, int start, StringBuilder string) {
            int c;
            int len = data.length();
            block4: for (c = start + 1; c < len; ++c) {
                char ch = data.charAt(c);
                switch (ch) {
                    case '\"': {
                        if (c >= data.length() - 1 || data.charAt(c + 1) != '\"') break block4;
                        ++c;
                        string.append('\"');
                        continue block4;
                    }
                    case '\\': {
                        if (++c < data.length()) {
                            ch = data.charAt(c);
                        }
                    }
                    default: {
                        string.append(ch);
                    }
                }
            }
            return c;
        }

        Object decode(String elementTxt, Type type, Context context) throws IOException {
            if (elementTxt.equals("NULL")) {
                return null;
            }
            return type.getCodec(ResultField.Format.Text).getDecoder().decode(type, null, null, elementTxt, context);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Object[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            buffer.writeInt(-1);
            if (val != null) {
                int writeStart = buffer.writerIndex();
                ArrayType atype = (ArrayType)type;
                Type elementType = atype.getElementType();
                int dimensionCount = Arrays.getDimensions(val.getClass(), atype.unwrapAll());
                buffer.writeInt(dimensionCount);
                buffer.writeInt(this.hasNulls(val) ? 1 : 0);
                buffer.writeInt(elementType.getId());
                Object dim = val;
                for (int d = 0; d < dimensionCount; ++d) {
                    int dimension = 0;
                    if (dim != null) {
                        dimension = Array.getLength(dim);
                    }
                    buffer.writeInt(dimension);
                    buffer.writeInt(1);
                    if (dimension == 0) {
                        dim = null;
                        continue;
                    }
                    if (dim == null) continue;
                    dim = Array.get(dim, 0);
                }
                this.writeArray(buffer, elementType, val, context);
                buffer.setInt(writeStart - 4, buffer.writerIndex() - writeStart);
            }
        }

        void writeArray(ByteBuf buffer, Type type, Object val, Context context) throws IOException {
            if (val.getClass().getComponentType().isArray() && !type.getBinaryCodec().getEncoder().getInputType().isArray()) {
                this.writeSubArray(buffer, type, val, context);
            } else {
                this.writeElements(buffer, type, val, context);
            }
        }

        void writeElements(ByteBuf buffer, Type type, Object val, Context context) throws IOException {
            int len = Array.getLength(val);
            for (int c = 0; c < len; ++c) {
                type.getBinaryCodec().getEncoder().encode(type, buffer, Array.get(val, c), context);
            }
        }

        void writeSubArray(ByteBuf buffer, Type type, Object val, Context context) throws IOException {
            int len = Array.getLength(val);
            for (int c = 0; c < len; ++c) {
                this.writeArray(buffer, type, Array.get(val, c), context);
            }
        }

        boolean hasNulls(Object value) {
            int sz = Array.getLength(value);
            for (int c = 0; c < sz; ++c) {
                if (Array.get(value, c) != null) continue;
                return true;
            }
            return false;
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public Class<?> getOutputType() {
            return Object[].class;
        }

        @Override
        public Object decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            int readStart = buffer.readerIndex();
            Object instance = null;
            if (length != -1) {
                ArrayType atype = (ArrayType)type;
                int dimensionCount = buffer.readInt();
                buffer.readInt();
                Type elementType = context.getRegistry().loadType(buffer.readInt());
                int[] dimensions = new int[dimensionCount];
                int[] lowerBounds = new int[dimensionCount];
                for (int d = 0; d < dimensionCount; ++d) {
                    dimensions[d] = buffer.readInt();
                    lowerBounds[d] = buffer.readInt();
                }
                if (atype.getElementType().getId() != elementType.getId()) {
                    context.refreshType(atype.getId());
                }
                instance = this.readArray(buffer, elementType, dimensions, context);
                if (length != buffer.readerIndex() - readStart) {
                    throw new IOException("invalid length");
                }
            }
            return instance;
        }

        Object readArray(ByteBuf buffer, Type type, int[] dims, Context context) throws IOException {
            if (dims.length == 0) {
                return this.readElements(buffer, type, 0, context);
            }
            if (dims.length == 1) {
                return this.readElements(buffer, type, dims[0], context);
            }
            return this.readSubArray(buffer, type, dims, context);
        }

        Object readSubArray(ByteBuf buffer, Type type, int[] dims, Context context) throws IOException {
            Class<?> elementClass = type.unwrap().getJavaType(ResultField.Format.Binary, Collections.emptyMap());
            Object inst = Array.newInstance(elementClass, dims);
            int[] subDims = java.util.Arrays.copyOfRange(dims, 1, dims.length);
            for (int c = 0; c < dims[0]; ++c) {
                Array.set(inst, c, this.readArray(buffer, type, subDims, context));
            }
            return inst;
        }

        Object readElements(ByteBuf buffer, Type type, int len, Context context) throws IOException {
            Class<?> elementClass = type.unwrap().getJavaType(ResultField.Format.Binary, Collections.emptyMap());
            Object inst = Array.newInstance(elementClass, len);
            for (int c = 0; c < len; ++c) {
                Array.set(inst, c, type.getBinaryCodec().getDecoder().decode(type, null, null, buffer, context));
            }
            return inst;
        }
    }
}

