/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import com.impossibl.postgres.api.data.Path;
import java.util.Arrays;

public enum GeometryParsers {
    INSTANCE;


    public Path parsePath(CharSequence s2) {
        return this.parsePath(s2, true);
    }

    public double[][] parsePolygon(CharSequence s2) {
        Path path = this.parsePath(s2, false);
        return path.getPoints();
    }

    public double[] parseCircle(CharSequence s2) {
        int idx;
        boolean delim;
        int max = s2.length() - 1;
        int pos = GeometryParsers.consummeSpace(s2, 0, true);
        char endDelim = ' ';
        if (s2.charAt(pos) == '<') {
            ++pos;
            delim = true;
            endDelim = '>';
        } else if (s2.charAt(pos) == '(') {
            idx = pos++;
            if ((pos = GeometryParsers.consummeSpace(s2, pos, true)) < max && s2.charAt(pos) == '(') {
                delim = true;
                endDelim = ')';
                pos = idx + 1;
            } else {
                delim = false;
                pos = idx;
            }
        } else {
            delim = false;
        }
        double[] point = new double[2];
        pos = this.parsePoint(s2, pos, point);
        pos = GeometryParsers.consummeSpace(s2, pos, true);
        if (s2.charAt(pos) != ',') {
            throw new IllegalArgumentException("near " + pos + " in  " + s2 + " - " + s2.charAt(pos));
        }
        ++pos;
        idx = pos = GeometryParsers.consummeSpace(s2, pos, true);
        if (delim) {
            while (pos <= max && s2.charAt(pos) != endDelim) {
                ++pos;
            }
            if (idx == pos) {
                throw new IllegalArgumentException("near " + idx + " in  " + s2);
            }
        } else {
            pos = this.parseNumber(s2, pos);
        }
        double radius = Double.parseDouble(s2.subSequence(idx, pos).toString());
        if ((pos = GeometryParsers.consummeSpace(s2, pos, false)) < max) {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        return new double[]{point[0], point[1], radius};
    }

    public double[] parsePoint(CharSequence s2) {
        double[] point = new double[2];
        int pos = this.parsePoint(s2, 0, point);
        if ((pos = GeometryParsers.consummeSpace(s2, pos, false)) < s2.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        return point;
    }

    public double[] parseBox(CharSequence s2) {
        PathResult pr = this.parsePath(false, 2, s2, 0);
        int pos = GeometryParsers.consummeSpace(s2, pr.pos, false);
        if (pos < s2.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        return new double[]{pr.p[0][0], pr.p[0][1], pr.p[1][0], pr.p[1][1]};
    }

    public double[] parseLSeg(CharSequence s2) {
        PathResult pr = this.parsePath(true, 2, s2, 0);
        int pos = GeometryParsers.consummeSpace(s2, pr.pos, false);
        if (pos < s2.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        return new double[]{pr.p[0][0], pr.p[0][1], pr.p[1][0], pr.p[1][1]};
    }

    public double[] parseLine(CharSequence s2) {
        double[] result;
        int pos = GeometryParsers.consummeSpace(s2, 0, true);
        if (s2.charAt(pos) == '{') {
            result = new double[3];
            pos = this.parseLineABC(s2, pos, result);
        } else {
            PathResult pr = this.parsePath(true, 2, s2, pos);
            if (Arrays.equals(pr.p[0], pr.p[1])) {
                throw new IllegalArgumentException("invalid line specification: must be two distinct points");
            }
            pos = pr.pos;
            result = GeometryParsers.lineConstructPts(pr.p[0], pr.p[1]);
        }
        pos = GeometryParsers.consummeSpace(s2, pos, false);
        if (pos < s2.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        return result;
    }

    private static double[] lineConstructPts(double[] pt1, double[] pt2) {
        double[] lineabc = new double[3];
        if (pt1[0] == pt2[0]) {
            lineabc[0] = -1.0;
            lineabc[1] = 0.0;
            lineabc[2] = pt1[0];
        } else if (pt1[1] == pt2[1]) {
            lineabc[0] = 0.0;
            lineabc[1] = -1.0;
            lineabc[2] = pt1[1];
        } else {
            lineabc[0] = (pt2[1] - pt1[1]) / (pt2[0] - pt1[0]);
            lineabc[1] = -1.0;
            lineabc[2] = pt1[1] - lineabc[0] * pt1[0];
        }
        return lineabc;
    }

    private int parseLineABC(CharSequence s2, int pos, double[] abc) {
        if (s2.charAt(pos) != '{') {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        int pos1 = ++pos;
        pos = this.parseNumber(s2, pos);
        double a = Double.parseDouble(s2.subSequence(pos1, pos).toString());
        if (s2.charAt(pos = GeometryParsers.consummeSpace(s2, pos, true)) != ',') {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        ++pos;
        pos1 = pos = GeometryParsers.consummeSpace(s2, pos, true);
        pos = this.parseNumber(s2, pos);
        double b = Double.parseDouble(s2.subSequence(pos1, pos).toString());
        if (a == 0.0 && b == 0.0) {
            throw new IllegalArgumentException("invalid line specification: A and B cannot both be zero");
        }
        if (s2.charAt(pos = GeometryParsers.consummeSpace(s2, pos, true)) != ',') {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        ++pos;
        pos1 = pos = GeometryParsers.consummeSpace(s2, pos, true);
        pos = this.parseNumber(s2, pos);
        double c = Double.parseDouble(s2.subSequence(pos1, pos).toString());
        if (s2.charAt(pos = GeometryParsers.consummeSpace(s2, pos, true)) != '}') {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        abc[0] = a;
        abc[1] = b;
        abc[2] = c;
        return ++pos;
    }

    private Path parsePath(CharSequence s2, boolean acceptopen) {
        int npts = GeometryParsers.pairCount(s2, ',');
        if (npts < 0) {
            throw new IllegalArgumentException("invalid input syntax for type path: " + s2);
        }
        int pos = GeometryParsers.consummeSpace(s2, 0, true);
        int max = s2.length() - 1;
        int depth = 0;
        if (s2.charAt(pos) == '(' && GeometryParsers.findLastDelim(s2, pos, '(') == pos + 1) {
            ++pos;
            ++depth;
        }
        PathResult pr = this.parsePath(acceptopen, npts, s2, GeometryParsers.consummeSpace(s2, pos, true));
        if (depth != 0) {
            pr.pos = GeometryParsers.consummeSpace(s2, pr.pos, true);
            if (s2.charAt(pr.pos) != ')') {
                throw new IllegalArgumentException("near " + pr.pos + " in  " + s2);
            }
        }
        pr.pos = GeometryParsers.consummeSpace(s2, pr.pos, false);
        if (pr.pos < max) {
            throw new IllegalArgumentException("near " + pr.pos + " in  " + s2);
        }
        return new Path(pr.p, !pr.isOpen);
    }

    private static int pairCount(CharSequence s2, char delim) {
        int ndelim = 0;
        int max = s2.length() - 1;
        for (int pos = 0; pos < max; ++pos) {
            if (s2.charAt(pos) != delim) continue;
            ++ndelim;
        }
        return ndelim % 2 == 0 ? -1 : (ndelim + 1) / 2;
    }

    public static void main(String ... args) {
        String[] paths;
        String[] lsegs;
        String[] boxes;
        String[] points;
        String[] numbers;
        String[] circles;
        System.out.println("Circles ===========");
        for (String c : circles = new String[]{"124.66, -565.88, 1256.6", "(124.66, -565.88), 1256.6", "((124.66, -565.88), 1256.6)", "<(124.66, -565.88), 1256.6>"}) {
            System.out.println(c + " --> " + Arrays.toString(INSTANCE.parseCircle(c)));
        }
        System.out.println("Numbers ===========");
        for (String n : numbers = new String[]{"99.4", "89E03", "8e-3", "45.3E+45"}) {
            int pos = INSTANCE.parseNumber(n, 0);
            System.out.println(n + " " + pos + " " + n.length() + " " + n.substring(0, pos));
        }
        System.out.println("Points ===========");
        for (String p : points = new String[]{"(100, 100)", "(-343.43, 43.01)", "100.0, 99.4", "(0,0)", "(124, 24343)", "(-113.7, +8989.98)", "(100e+2, 100e-2)", "(-343.43, 43.01)", "100.0e4, 99.4e-2"}) {
            try {
                double[] point = INSTANCE.parsePoint(p);
                System.out.println(p + " --> " + Arrays.toString(point));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Boxes ===========");
        for (String box : boxes = new String[]{"((678.6,454),(124.6,0))", "(678.6,454),(124.6,0)", "(0,0),(0,0)", "(-678.6, -454),(124.6,1.0)", "-678.6, -454,124.6,1.0", "(10, 20),(100, 120)"}) {
            try {
                double[] b = INSTANCE.parseBox(box);
                System.out.println(box + " --> " + Arrays.toString(b));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("LSegs ===========");
        for (String lseg : lsegs = new String[]{"[(678.6,454),(124.6,0)]", "((678.6,454),(124.6,0))", "(678.6,454),(124.6,0)", "(0,0),(0,0)", "(-678.6, -454),(124.6,1.0)", "-678.6, -454,124.6,1.0", "(10, 20),(100, 120)"}) {
            try {
                double[] b = INSTANCE.parseLSeg(lseg);
                System.out.println(lseg + " --> " + Arrays.toString(b));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Paths ===========");
        for (String path : paths = new String[]{"[(678.6,454)]", "((678.6,454))", "[(678.6,454),(124.6,0)]", "((678.6,454),(124.6,0))", "(678.6,454),(124.6,0)", "(0,0),(0,0)", "(-678.6, -454),(124.6,1.0)", "-678.6, -454,124.6,1.0", "(10, 20),(100, 120)", "[(678.6,454),(10,89),(124.6,0)]", "((678.6,454),(10,89),(124.6,0))", "(678.6,454),(10,89),(124.6,0)", "(0,0),(10,89),(0,0)", "(-678.6, -454),(10,89),(124.6,1.0)", "-678.6,10,89, -454,124.6,1.0", "(10, 20),(10,89),(100, 120)"}) {
            try {
                Path pr = INSTANCE.parsePath(path);
                System.out.println(path + " --> " + pr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static int findLastDelim(CharSequence s2, int pos, char delim) {
        int found = -1;
        int max = s2.length() - 1;
        while (pos < max) {
            if (s2.charAt(pos) == delim) {
                found = pos;
            }
            ++pos;
        }
        return found;
    }

    private PathResult parsePath(boolean opendelim, int npts, CharSequence s2, int pos) {
        PathResult pr = new PathResult();
        int depth = 0;
        pr.pos = GeometryParsers.consummeSpace(s2, pos, true);
        char c = s2.charAt(pr.pos);
        if (c == '[') {
            pr.isOpen = true;
            if (!opendelim) {
                throw new IllegalArgumentException("near " + pr.pos + " in  " + s2);
            }
            ++pr.pos;
            ++depth;
            pr.pos = GeometryParsers.consummeSpace(s2, pr.pos, true);
        } else if (c == '(') {
            int cp = GeometryParsers.consummeSpace(s2, pr.pos + 1, true);
            if (s2.charAt(cp) == '(') {
                if (npts <= 1) {
                    throw new IllegalArgumentException("near " + pr.pos + " in  " + s2);
                }
                ++depth;
                pr.pos = cp;
            } else if (GeometryParsers.findLastDelim(s2, pr.pos, '(') == cp) {
                ++depth;
                pr.pos = cp;
            }
        }
        pr.p = new double[npts][];
        int max = s2.length() - 1;
        for (int i = 0; i < npts; ++i) {
            double[] points = new double[2];
            pr.pos = this.parsePoint(s2, pr.pos, points);
            pr.pos = GeometryParsers.consummeSpace(s2, pr.pos, i < npts - 1);
            if (pr.pos < max && s2.charAt(pr.pos) == ',') {
                ++pr.pos;
            }
            pr.p[i] = points;
        }
        while (depth > 0) {
            if (s2.charAt(pr.pos) == ')' || s2.charAt(pr.pos) == ']' && pr.isOpen && depth == 1) {
                pr.pos = GeometryParsers.consummeSpace(s2, ++pr.pos, --depth != 0);
                continue;
            }
            throw new IllegalArgumentException("near " + pr.pos + " in  " + s2);
        }
        return pr;
    }

    private int parsePoint(CharSequence s2, int pos, double[] p) {
        double p2;
        int max = s2.length() - 1;
        pos = GeometryParsers.consummeSpace(s2, pos, true);
        boolean delim = false;
        if ('(' == s2.charAt(pos)) {
            ++pos;
            delim = true;
        }
        int pos1 = pos = GeometryParsers.consummeSpace(s2, pos, true);
        while (pos <= max && ',' != s2.charAt(pos)) {
            ++pos;
        }
        double p1 = Double.parseDouble(s2.subSequence(pos1, pos).toString());
        ++pos;
        pos1 = pos = GeometryParsers.consummeSpace(s2, pos, true);
        if (delim) {
            while (pos <= max && ')' != s2.charAt(pos)) {
                ++pos;
            }
            p2 = Double.parseDouble(s2.subSequence(pos1, pos).toString());
        } else {
            pos = this.parseNumber(s2, pos);
            p2 = Double.parseDouble(s2.subSequence(pos1, pos).toString());
        }
        pos = GeometryParsers.consummeSpace(s2, pos, delim);
        if (delim) {
            if (s2.charAt(pos) != ')') {
                throw new IllegalArgumentException("near " + pos + " in  " + s2);
            }
            ++pos;
        }
        p[0] = p1;
        p[1] = p2;
        return pos;
    }

    private static int parseExponent(CharSequence s2, int pos) {
        int max = s2.length() - 1;
        if (pos >= max) {
            return pos;
        }
        char c = s2.charAt(pos);
        if (c == 'e' || c == 'E') {
            if (++pos >= max) {
                throw new NumberFormatException("near " + pos + " in  " + s2);
            }
            c = s2.charAt(pos);
            if (c == '-' || c == '+') {
                ++pos;
            }
            if (pos > max) {
                throw new NumberFormatException("near " + pos + " in  " + s2);
            }
            int initpos = pos;
            while (pos <= max && Character.isDigit(s2.charAt(pos))) {
                ++pos;
            }
            if (initpos == pos) {
                throw new NumberFormatException("near " + pos + " in  " + s2);
            }
        }
        return pos;
    }

    private int parseNumber(CharSequence s2, int pos) {
        int max = s2.length() - 1;
        switch (s2.charAt(pos)) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean dot = s2.charAt(pos) == '.';
                ++pos;
                while (pos <= max) {
                    char c = s2.charAt(pos);
                    if ('.' == c) {
                        if (dot) {
                            throw new NumberFormatException("near " + pos + " in  " + s2);
                        }
                        dot = true;
                    } else if ((c < '0' || c > '9') && !Character.isDigit(c)) break;
                    ++pos;
                }
                if (pos > max) break;
                pos = GeometryParsers.parseExponent(s2, pos);
            }
        }
        return pos;
    }

    private static int consummeSpace(CharSequence s2, int pos, boolean checkEOS) {
        int max = s2.length() - 1;
        while (pos <= max && Character.isSpaceChar(s2.charAt(pos))) {
            ++pos;
        }
        if (checkEOS && pos > max) {
            throw new IllegalArgumentException("near " + pos + " in  " + s2);
        }
        return pos;
    }

    static class PathResult {
        int pos;
        double[][] p;
        boolean isOpen = false;

        PathResult() {
        }
    }
}

