/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.HttpClient;
import com.microsoft.applicationinsights.core.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.CloseableHttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.CloseableHttpClient;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.HttpClients;
import com.microsoft.applicationinsights.core.dependencies.http.impl.conn.PoolingHttpClientConnectionManager;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ApacheSender43
implements ApacheSender {
    private final AtomicReference<CloseableHttpClient> httpClientRef = new AtomicReference();
    private volatile boolean isClientInitialized = false;
    private final ExecutorService initializer = Executors.newSingleThreadExecutor();

    public ApacheSender43() {
        this.initializer.execute(new Runnable(){

            @Override
            public void run() {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(200);
                cm.setDefaultMaxPerRoute(20);
                ApacheSender43.this.httpClientRef.compareAndSet(null, HttpClients.custom().setConnectionManager(cm).useSystemProperties().build());
            }
        });
        SDKShutdownActivity.INSTANCE.register(this.initializer);
    }

    @Override
    public HttpResponse sendPostRequest(HttpPost post) throws IOException {
        return this.getHttpClient().execute(post);
    }

    @Override
    public void dispose(HttpResponse response) {
        try {
            if (response != null) {
                ((CloseableHttpResponse)response).close();
            }
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to send or failed to close response, exception: %s", e.toString());
        }
    }

    @Override
    public void close() {
        try {
            ((CloseableHttpClient)this.getHttpClient()).close();
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to close http client, exception: %s", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getHttpClient() {
        if (!this.isClientInitialized) {
            ApacheSender43 apacheSender43 = this;
            synchronized (apacheSender43) {
                if (!this.isClientInitialized) {
                    while (this.httpClientRef.get() == null) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(3L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.isClientInitialized = true;
                }
            }
        }
        return this.httpClientRef.get();
    }

    @Override
    public void enhanceRequest(HttpPost request) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).setSocketTimeout(60000).build();
        request.setConfig(requestConfig);
    }
}

