/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.Obsolete;
import java.net.URI;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class Sanitizer {
    public static final int MAX_MAP_NAME_LENGTH = 150;
    public static final int MAX_VALUE_LENGTH = 8192;
    public static final int MAX_NAME_LENGTH = 1024;
    public static final int MAX_MESSAGE_LENGTH = 32768;
    public static final int MAX_URL_LENGTH = 2048;
    private static final String INVALID_NAME_CHARACTERS = "[^0-9a-zA-Z-._()\\/ ]";

    @Obsolete
    public static void sanitizeProperties(Map<String, String> map) {
        if (map != null) {
            HashMap<String, String> tempMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String sanitizedKey = Sanitizer.sanitizeKey(entry.getKey(), tempMap);
                String sanitizedValue = Sanitizer.sanitizeValue(entry.getValue());
                tempMap.put(sanitizedKey, sanitizedValue);
            }
            map.clear();
            map.putAll(tempMap);
        }
    }

    @Obsolete
    public static void sanitizeMeasurements(Map<String, Double> map) {
        if (map != null) {
            HashMap<String, Double> tempMap = new HashMap<String, Double>(map.size());
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                String sanitizedKey = Sanitizer.sanitizeKey(entry.getKey(), tempMap);
                tempMap.put(sanitizedKey, entry.getValue());
            }
            map.clear();
            map.putAll(tempMap);
        }
    }

    public static URI sanitizeUri(String urlAsString) {
        if (!Strings.isNullOrEmpty(urlAsString)) {
            if (urlAsString.length() > 2048) {
                urlAsString = urlAsString.substring(0, 2048);
            }
            URI temp = null;
            try {
                temp = new URI(urlAsString);
                return temp;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Obsolete
    public static String sanitizeValue(String value) {
        String truncatedString = Sanitizer.trimAndTruncate(value, 8192);
        String sanitizedString = Sanitizer.sanitizeStringForJSON(truncatedString, 8192);
        return sanitizedString;
    }

    @Obsolete
    public static String sanitizeName(String name) {
        return Sanitizer.trimAndTruncate(name, 1024);
    }

    @Obsolete
    public static String sanitizeMessage(String message) {
        return Sanitizer.trimAndTruncate(message, 32768);
    }

    @Obsolete
    public static boolean isUUID(String possibleUUID) {
        try {
            UUID.fromString(possibleUUID);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static URI safeStringToUri(String url) {
        if (Strings.isNullOrEmpty(url)) {
            return null;
        }
        URI result = null;
        try {
            result = new URI(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Obsolete
    private static <V> String sanitizeKey(String key, Map<String, V> map) {
        String sanitizedKey = Sanitizer.trimAndTruncate(key, 150);
        sanitizedKey = Sanitizer.sanitizeStringForJSON(sanitizedKey, 150);
        sanitizedKey = Sanitizer.MakeKeyNonEmpty(sanitizedKey);
        sanitizedKey = Sanitizer.MakeKeyUnique(sanitizedKey, map);
        return sanitizedKey;
    }

    @Obsolete
    private static String trimAndTruncate(String value, int maxLength) {
        if (value == null) {
            return value;
        }
        String sanitized = value.trim();
        if (sanitized.length() > maxLength) {
            sanitized = sanitized.substring(0, maxLength);
        }
        return sanitized;
    }

    @Obsolete
    private static String MakeKeyNonEmpty(String key) {
        return Strings.isNullOrEmpty(key) ? "(required property name is empty)" : key;
    }

    @Obsolete
    private static <V> String MakeKeyUnique(String key, Map<String, V> map) {
        if (map.containsKey(key)) {
            int uniqueNumberLength = 3;
            String truncatedKey = Sanitizer.truncate(key, 150 - uniqueNumberLength);
            int candidate = 1;
            do {
                key = truncatedKey + String.format("%0%dd", uniqueNumberLength, candidate);
                ++candidate;
            } while (map.containsKey(key));
        }
        return key;
    }

    @Obsolete
    private static String truncate(String value, int maxLength) {
        return value.length() > maxLength ? value.substring(0, maxLength) : value;
    }

    @Obsolete
    private static String sanitizeStringForJSON(String text, int maxLength) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char curr = iterator.current();
        while (true) {
            if (curr == '\uffff' || result.length() >= maxLength - 2) break;
            if (curr == '\"') {
                result.append("\\\"");
            } else if (curr == '\'') {
                result.append("\\'");
            } else if (curr == '\\') {
                result.append("\\\\");
            } else if (curr == '/') {
                result.append("\\/");
            } else if (curr == '\b') {
                result.append("\\b");
            } else if (curr == '\f') {
                result.append("\\f");
            } else if (curr == '\n') {
                result.append("\\n");
            } else if (curr == '\r') {
                result.append("\\r");
            } else if (curr == '\t') {
                result.append("\\t");
            } else if (!Character.isISOControl(curr)) {
                result.append(curr);
            } else {
                if (result.length() + 7 >= maxLength) break;
                result.append("\\u");
                result.append(String.format("%04x", curr));
            }
            curr = iterator.next();
        }
        return result.toString();
    }
}

