/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.bibtex.BibTeXConverter;
import de.undercouch.citeproc.bibtex.BibTeXItemDataProvider;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.endnote.EndNoteConverter;
import de.undercouch.citeproc.endnote.EndNoteItemDataProvider;
import de.undercouch.citeproc.endnote.EndNoteLibrary;
import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.ris.RISConverter;
import de.undercouch.citeproc.ris.RISItemDataProvider;
import de.undercouch.citeproc.ris.RISLibrary;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.ParseException;

public class BibliographyFileReader {
    public ItemDataProvider readBibliographyFile(File bibfile) throws FileNotFoundException, IOException {
        if (!bibfile.exists()) {
            throw new FileNotFoundException("Bibliography file `" + bibfile.getName() + "' does not exist");
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(bibfile));){
            ItemDataProvider itemDataProvider = this.readBibliographyFile((InputStream)bis, bibfile.getName());
            return itemDataProvider;
        }
    }

    public ItemDataProvider readBibliographyFile(InputStream bibstream, String filename) throws IOException {
        BufferedInputStream bis = bibstream instanceof BufferedInputStream ? (BufferedInputStream)bibstream : new BufferedInputStream(bibstream);
        FileFormat ff = this.determineFileFormat(bis, filename);
        return this.readBibliographyFile((InputStream)bis, ff);
    }

    public ItemDataProvider readBibliographyFile(InputStream bibstream, FileFormat format) throws IOException {
        ListItemDataProvider provider;
        block9: {
            try {
                if (format == FileFormat.BIBTEX) {
                    BibTeXDatabase db = new BibTeXConverter().loadDatabase(bibstream);
                    BibTeXItemDataProvider bibtexprovider = new BibTeXItemDataProvider();
                    bibtexprovider.addDatabase(db);
                    provider = bibtexprovider;
                    break block9;
                }
                if (format == FileFormat.JSON_ARRAY || format == FileFormat.JSON_OBJECT) {
                    List<Object> objs;
                    JsonParser parser = new JsonParser(new JsonLexer(new InputStreamReader(bibstream)));
                    if (format == FileFormat.JSON_ARRAY) {
                        objs = parser.parseArray();
                    } else {
                        objs = new ArrayList<Object>();
                        objs.add(parser.parseObject());
                    }
                    CSLItemData[] items = new CSLItemData[objs.size()];
                    for (int i = 0; i < items.length; ++i) {
                        Map obj = (Map)objs.get(i);
                        items[i] = CSLItemData.fromJson(obj);
                    }
                    provider = new ListItemDataProvider(items);
                    break block9;
                }
                if (format == FileFormat.ENDNOTE) {
                    EndNoteLibrary lib = new EndNoteConverter().loadLibrary(bibstream);
                    EndNoteItemDataProvider endnoteprovider = new EndNoteItemDataProvider();
                    endnoteprovider.addLibrary(lib);
                    provider = endnoteprovider;
                    break block9;
                }
                if (format == FileFormat.RIS) {
                    RISLibrary lib = new RISConverter().loadLibrary(bibstream);
                    RISItemDataProvider risprovider = new RISItemDataProvider();
                    risprovider.addLibrary(lib);
                    provider = risprovider;
                    break block9;
                }
                throw new IOException("Unknown bibliography file format");
            }
            catch (ParseException e) {
                throw new IOException("Could not parse bibliography file", e);
            }
        }
        return provider;
    }

    public FileFormat determineFileFormat(File bibfile) throws FileNotFoundException, IOException {
        if (!bibfile.exists()) {
            throw new FileNotFoundException("Bibliography file `" + bibfile.getName() + "' does not exist");
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(bibfile));){
            FileFormat fileFormat = this.determineFileFormat(bis, bibfile.getName());
            return fileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileFormat determineFileFormat(BufferedInputStream bis, String filename) throws IOException {
        int dot;
        int len = 102400;
        String ext = "";
        if (filename != null && (dot = filename.lastIndexOf(46)) > 0) {
            ext = filename.substring(dot + 1);
        }
        bis.mark(len);
        try {
            byte[] firstCharacters = new byte[5];
            bis.read(firstCharacters);
            if (firstCharacters[0] == 37 && Character.isWhitespace(firstCharacters[2]) && !ext.equalsIgnoreCase("bib")) {
                FileFormat fileFormat = FileFormat.ENDNOTE;
                return fileFormat;
            }
            if (firstCharacters[0] == 84 && firstCharacters[1] == 89 && Character.isWhitespace(firstCharacters[2]) && Character.isWhitespace(firstCharacters[3]) && firstCharacters[4] == 45) {
                FileFormat fileFormat = FileFormat.RIS;
                return fileFormat;
            }
        }
        finally {
            bis.reset();
        }
        bis.mark(len);
        try {
            while (true) {
                int c;
                if ((c = bis.read()) < 0 || --len < 2) {
                    FileFormat fileFormat = FileFormat.UNKNOWN;
                    return fileFormat;
                }
                if (Character.isWhitespace(c)) continue;
                if (c == 91) {
                    FileFormat fileFormat = FileFormat.JSON_ARRAY;
                    return fileFormat;
                }
                if (c == 123) {
                    FileFormat fileFormat = FileFormat.JSON_OBJECT;
                    return fileFormat;
                }
                FileFormat fileFormat = FileFormat.BIBTEX;
                return fileFormat;
            }
        }
        finally {
            bis.reset();
        }
    }

    public static enum FileFormat {
        BIBTEX,
        JSON_OBJECT,
        JSON_ARRAY,
        ENDNOTE,
        RIS,
        UNKNOWN;

    }
}

