/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLCitation;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.List;

public class CitationIDIndexPair
implements JsonObject {
    private final String citationId;
    private final int noteIndex;

    public CitationIDIndexPair(String citationId, int noteIndex) {
        this.citationId = citationId;
        this.noteIndex = noteIndex;
    }

    public CitationIDIndexPair(CSLCitation citation) {
        this.citationId = citation.getCitationID();
        this.noteIndex = citation.getProperties().getNoteIndex();
    }

    public String getCitationId() {
        return this.citationId;
    }

    public int getNoteIndex() {
        return this.noteIndex;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        return builder.toJson(new Object[]{this.citationId, this.noteIndex});
    }

    public static CitationIDIndexPair fromJson(List<?> arr) {
        String citationId = (String)arr.get(0);
        int noteIndex = ((Number)arr.get(1)).intValue();
        return new CitationIDIndexPair(citationId, noteIndex);
    }
}

