/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.endnote;

import de.undercouch.citeproc.endnote.EndNoteLibrary;
import de.undercouch.citeproc.endnote.EndNoteReferenceBuilder;
import de.undercouch.citeproc.endnote.EndNoteType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class EndNoteParser {
    public EndNoteLibrary parse(Reader r) throws IOException {
        String line;
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        EndNoteLibrary result = new EndNoteLibrary();
        EndNoteReferenceBuilder builder = null;
        ArrayList<String> authors = new ArrayList<String>();
        ArrayList<String> editors = new ArrayList<String>();
        ArrayList<String> translatedAuthors = new ArrayList<String>();
        ArrayList<String> keywords = new ArrayList<String>();
        ArrayList<String> notes = new ArrayList<String>();
        ArrayList<String> tertiaryAuthors = new ArrayList<String>();
        ArrayList<String> subsidiaryAuthors = new ArrayList<String>();
        int lc = 0;
        block54: while ((line = br.readLine()) != null) {
            ++lc;
            if ((line = line.trim()).isEmpty()) {
                this.handleReference(builder, authors, editors, translatedAuthors, keywords, notes, tertiaryAuthors, subsidiaryAuthors, result);
                authors.clear();
                editors.clear();
                translatedAuthors.clear();
                keywords.clear();
                notes.clear();
                tertiaryAuthors.clear();
                subsidiaryAuthors.clear();
                builder = null;
                continue;
            }
            if (line.length() < 4) {
                throw new IOException("Line " + lc + " is too short");
            }
            if (line.charAt(0) != '%') {
                throw new IOException("Illegal first character in line " + lc);
            }
            if (!Character.isWhitespace(line.charAt(2))) {
                throw new IOException("Tag and value must be separated by whitespace character in line " + lc);
            }
            String key = line.substring(1, 2).trim();
            String value = line.substring(3).trim();
            if (builder == null) {
                builder = new EndNoteReferenceBuilder();
            }
            switch (line.charAt(1)) {
                case '0': {
                    builder.type(this.parseType(value, lc));
                    continue block54;
                }
                case '1': {
                    builder.custom1(value);
                    continue block54;
                }
                case '2': {
                    builder.custom2(value);
                    continue block54;
                }
                case '3': {
                    builder.custom3(value);
                    continue block54;
                }
                case '4': {
                    builder.custom4(value);
                    continue block54;
                }
                case '6': {
                    builder.numberOfVolumes(value);
                    continue block54;
                }
                case '7': {
                    builder.edition(value);
                    continue block54;
                }
                case '8': {
                    builder.date(value);
                    continue block54;
                }
                case '9': {
                    builder.typeOfWork(value);
                    continue block54;
                }
                case 'A': {
                    authors.add(value);
                    continue block54;
                }
                case 'B': {
                    builder.bookOrConference(value);
                    continue block54;
                }
                case 'C': {
                    builder.place(value);
                    continue block54;
                }
                case 'D': {
                    builder.year(value);
                    continue block54;
                }
                case 'E': {
                    editors.add(value);
                    continue block54;
                }
                case 'F': {
                    builder.label(value);
                    continue block54;
                }
                case 'G': {
                    builder.language(value);
                    continue block54;
                }
                case 'H': {
                    translatedAuthors.add(value);
                    continue block54;
                }
                case 'I': {
                    builder.publisher(value);
                    continue block54;
                }
                case 'J': {
                    builder.journal(value);
                    continue block54;
                }
                case 'K': {
                    keywords.add(value);
                    continue block54;
                }
                case 'L': {
                    builder.callNumber(value);
                    continue block54;
                }
                case 'M': {
                    builder.accessionNumber(value);
                    continue block54;
                }
                case 'N': {
                    builder.numberOrIssue(value);
                    continue block54;
                }
                case 'O': {
                    notes.add(value);
                    continue block54;
                }
                case 'P': {
                    builder.pages(value);
                    continue block54;
                }
                case 'Q': {
                    builder.translatedTitle(value);
                    continue block54;
                }
                case 'R': {
                    builder.electronicResourceNumber(value);
                    continue block54;
                }
                case 'S': {
                    builder.tertiaryTitle(value);
                    continue block54;
                }
                case 'T': {
                    builder.title(value);
                    continue block54;
                }
                case 'U': {
                    builder.URL(value);
                    continue block54;
                }
                case 'V': {
                    builder.volume(value);
                    continue block54;
                }
                case 'W': {
                    builder.databaseProvider(value);
                    continue block54;
                }
                case 'X': {
                    builder.abstrct(value);
                    continue block54;
                }
                case 'Y': {
                    tertiaryAuthors.add(value);
                    continue block54;
                }
                case 'Z': {
                    notes.add(value);
                    continue block54;
                }
                case '?': {
                    subsidiaryAuthors.add(value);
                    continue block54;
                }
                case '@': {
                    builder.isbnOrIssn(value);
                    continue block54;
                }
                case '!': {
                    builder.shortTitle(value);
                    continue block54;
                }
                case '#': {
                    builder.custom5(value);
                    continue block54;
                }
                case '$': {
                    builder.custom6(value);
                    continue block54;
                }
                case ']': {
                    builder.custom7(value);
                    continue block54;
                }
                case '&': {
                    builder.section(value);
                    continue block54;
                }
                case '(': {
                    builder.originalPublication(value);
                    continue block54;
                }
                case ')': {
                    builder.reprintEdition(value);
                    continue block54;
                }
                case '*': {
                    builder.reviewedItem(value);
                    continue block54;
                }
                case '+': {
                    builder.authorAddress(value);
                    continue block54;
                }
                case '^': {
                    builder.caption(value);
                    continue block54;
                }
                case '>': {
                    builder.linkToPDF(value);
                    continue block54;
                }
                case '<': {
                    builder.researchNotes(value);
                    continue block54;
                }
                case '[': {
                    builder.accessDate(value);
                    continue block54;
                }
                case '=': {
                    builder.lastModifiedDate(value);
                    continue block54;
                }
                case '~': {
                    builder.nameOfDatabase(value);
                    continue block54;
                }
            }
            throw new IOException("Illegal tag " + key + " in line " + lc);
        }
        this.handleReference(builder, authors, editors, translatedAuthors, keywords, notes, tertiaryAuthors, subsidiaryAuthors, result);
        return result;
    }

    private void handleReference(EndNoteReferenceBuilder builder, List<String> authors, List<String> editors, List<String> translatedAuthors, List<String> keywords, List<String> notes, List<String> tertiaryAuthors, List<String> subsidiaryAuthors, EndNoteLibrary result) {
        if (builder != null) {
            if (!authors.isEmpty()) {
                builder.authors(authors.toArray(new String[authors.size()]));
            }
            if (!editors.isEmpty()) {
                builder.editors(editors.toArray(new String[editors.size()]));
            }
            if (!translatedAuthors.isEmpty()) {
                builder.translatedAuthors(translatedAuthors.toArray(new String[translatedAuthors.size()]));
            }
            if (!keywords.isEmpty()) {
                builder.keywords(keywords.toArray(new String[keywords.size()]));
            }
            if (!notes.isEmpty()) {
                builder.notes(notes.toArray(new String[notes.size()]));
            }
            if (!tertiaryAuthors.isEmpty()) {
                builder.tertiaryAuthors(tertiaryAuthors.toArray(new String[tertiaryAuthors.size()]));
            }
            if (!subsidiaryAuthors.isEmpty()) {
                builder.subsidiaryAuthors(subsidiaryAuthors.toArray(new String[subsidiaryAuthors.size()]));
            }
            result.addReference(builder.build());
        }
    }

    private EndNoteType parseType(String value, int lc) throws IOException {
        try {
            return EndNoteType.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Unknown type in line " + lc);
        }
    }
}

