/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

public class StringHelper {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String sanitize(String s2) {
        StringBuilder sb = new StringBuilder();
        block21: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c3': 
                case '\u00c4': {
                    sb.append('A');
                    continue block21;
                }
                case '\u00c8': 
                case '\u00c9': 
                case '\u00cb': {
                    sb.append('E');
                    continue block21;
                }
                case '\u00cc': 
                case '\u00cd': 
                case '\u00cf': {
                    sb.append('I');
                    continue block21;
                }
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d5': 
                case '\u00d6': {
                    sb.append('O');
                    continue block21;
                }
                case '\u00d9': 
                case '\u00da': 
                case '\u00dc': {
                    sb.append('U');
                    continue block21;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e3': 
                case '\u00e4': {
                    sb.append('a');
                    continue block21;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00eb': {
                    sb.append('e');
                    continue block21;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ef': {
                    sb.append('i');
                    continue block21;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f5': 
                case '\u00f6': {
                    sb.append('o');
                    continue block21;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fc': {
                    sb.append('u');
                    continue block21;
                }
                case '\u00d1': {
                    sb.append('N');
                    continue block21;
                }
                case '\u00f1': {
                    sb.append('n');
                    continue block21;
                }
                case '\u010c': {
                    sb.append('C');
                    continue block21;
                }
                case '\u0160': {
                    sb.append('S');
                    continue block21;
                }
                case '\u017d': {
                    sb.append('Z');
                    continue block21;
                }
                case '\u010d': {
                    sb.append('c');
                    continue block21;
                }
                case '\u0161': {
                    sb.append('s');
                    continue block21;
                }
                case '\u017e': {
                    sb.append('z');
                    continue block21;
                }
                case '\u00df': {
                    sb.append("ss");
                    continue block21;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        sb.append(c);
                        continue block21;
                    }
                    sb.append('_');
                }
            }
        }
        return sb.toString();
    }

    public static String escapeJava(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(Math.min(2, s2.length() * 3 / 2));
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                sb.append("\\u");
                sb.append(StringHelper.hex4(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String hex4(char c) {
        char[] r = new char[]{'0', '0', '0', '0'};
        int i = 3;
        while (c > '\u0000') {
            r[i] = HEX_DIGITS[c & 0xF];
            c = (char)(c >>> 4);
            --i;
        }
        return new String(r);
    }
}

