/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.oauth;

import de.undercouch.citeproc.helper.CSLUtils;
import de.undercouch.citeproc.helper.oauth.OAuth;
import de.undercouch.citeproc.helper.oauth.PercentEncoding;
import de.undercouch.citeproc.helper.oauth.RequestException;
import de.undercouch.citeproc.helper.oauth.Response;
import de.undercouch.citeproc.helper.oauth.Token;
import de.undercouch.citeproc.helper.oauth.UnauthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class OAuth1
implements OAuth {
    protected static final String OAUTH_TOKEN = "oauth_token";
    protected static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    private static final String OAUTH_CALLBACK = "oauth_callback";
    private static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String OAUTH_NONCE = "oauth_nonce";
    private static final String OAUTH_SIGNATURE = "oauth_signature";
    private static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String OAUTH_VERIFIER = "oauth_verifier";
    private static final String OAUTH_VERSION = "oauth_version";
    private static final String UTF8 = "UTF-8";
    private static final String OAUTH_IMPL_VERSION = "1.0";
    private static final String HMAC_SHA1_METHOD = "HMAC-SHA1";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_HOST = "Host";
    private static final String CALLBACK_OOB = "oob";
    private final String consumerKey;
    private final String consumerSecret;
    private final SecureRandom random = new SecureRandom();

    public OAuth1(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    @Override
    public Token requestTemporaryCredentials(URL url, OAuth.Method method) throws IOException {
        HashMap<String, String> aap = new HashMap<String, String>();
        aap.put(OAUTH_CALLBACK, CALLBACK_OOB);
        return this.requestCredentials(url, method, null, aap);
    }

    @Override
    public Token requestTokenCredentials(URL url, OAuth.Method method, Token temporaryCredentials, String verifier) throws IOException {
        HashMap<String, String> aap = new HashMap<String, String>();
        aap.put(OAUTH_VERIFIER, verifier);
        return this.requestCredentials(url, method, temporaryCredentials, aap);
    }

    @Override
    public Response request(URL url, OAuth.Method method, Token token) throws IOException {
        return this.request(url, method, token, null);
    }

    @Override
    public Response request(URL url, OAuth.Method method, Token token, Map<String, String> additionalHeaders) throws IOException {
        return this.requestInternal(url, method, token, null, additionalHeaders);
    }

    private Token requestCredentials(URL url, OAuth.Method method, Token token, Map<String, String> additionalAuthParams) throws IOException {
        Response r = this.requestInternal(url, method, token, additionalAuthParams, null);
        InputStream is = r.getInputStream();
        String response = CSLUtils.readStreamToString(is, UTF8);
        Map<String, String> sr = OAuth1.splitResponse(response);
        return this.responseToToken(sr);
    }

    protected Token responseToToken(Map<String, String> response) {
        return new Token(response.get(OAUTH_TOKEN), response.get(OAUTH_TOKEN_SECRET));
    }

    private Response requestInternal(URL url, OAuth.Method method, Token token, Map<String, String> additionalAuthParams, Map<String, String> additionalHeaders) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setRequestMethod(method.toString());
        conn.setRequestProperty(HEADER_HOST, OAuth1.makeBaseUri(url));
        String timestamp = OAuth1.makeTimestamp();
        String nonce = this.makeNonce(timestamp);
        HashMap<String, String> authParams = new HashMap<String, String>();
        if (additionalAuthParams != null) {
            authParams.putAll(additionalAuthParams);
        }
        if (token != null) {
            authParams.put(OAUTH_TOKEN, token.getToken());
        }
        authParams.put(OAUTH_CONSUMER_KEY, this.consumerKey);
        authParams.put(OAUTH_SIGNATURE_METHOD, HMAC_SHA1_METHOD);
        authParams.put(OAUTH_TIMESTAMP, timestamp);
        authParams.put(OAUTH_NONCE, nonce);
        authParams.put(OAUTH_VERSION, OAUTH_IMPL_VERSION);
        String signature = this.makeSignature(method.toString(), url, authParams, token);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : authParams.entrySet()) {
            OAuth1.appendAuthParam(sb, (String)entry.getKey(), (String)entry.getValue());
        }
        OAuth1.appendAuthParam(sb, OAUTH_SIGNATURE, signature);
        conn.setRequestProperty(HEADER_AUTHORIZATION, "OAuth " + sb.toString());
        if (additionalHeaders != null) {
            for (Map.Entry<Object, Object> entry : additionalHeaders.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        conn.connect();
        if (conn.getResponseCode() == 401) {
            throw new UnauthorizedException("Not authorized");
        }
        if (conn.getResponseCode() != 200) {
            throw new RequestException("HTTP request failed with error code: " + conn.getResponseCode());
        }
        return new Response(conn);
    }

    private static void appendAuthParam(StringBuilder sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(key);
        sb.append("=\"");
        sb.append(value);
        sb.append("\"");
    }

    private static String makeTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private String makeNonce(String timestamp) {
        byte[] bytes = new byte[10];
        this.random.nextBytes(bytes);
        StringBuilder sb = new StringBuilder(timestamp);
        sb.append("-");
        for (int i = 0; i < bytes.length; ++i) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                sb.append("0");
            }
            sb.append(b);
        }
        return sb.toString();
    }

    private static String makeBaseUri(URL url) {
        String r = url.getProtocol().toLowerCase() + "://" + url.getHost().toLowerCase();
        if (url.getProtocol().equalsIgnoreCase("http") && url.getPort() != -1 && url.getPort() != 80 || url.getProtocol().equalsIgnoreCase("https") && url.getPort() != -1 && url.getPort() != 443) {
            r = r + ":" + url.getPort();
        }
        return r;
    }

    private static List<String> splitAndEncodeParams(URL url) {
        if (url.getQuery() == null) {
            return new ArrayList<String>();
        }
        String[] params = url.getQuery().split("&");
        ArrayList<String> result = new ArrayList<String>(params.length);
        for (String p : params) {
            String[] kv = p.split("=");
            kv[0] = PercentEncoding.decode(kv[0]);
            kv[1] = PercentEncoding.decode(kv[1]);
            kv[0] = PercentEncoding.encode(kv[0]);
            kv[1] = PercentEncoding.encode(kv[1]);
            String np = kv[0] + "=" + kv[1];
            result.add(np);
        }
        return result;
    }

    private static Map<String, String> splitResponse(String response) {
        String[] params = response.split("&");
        HashMap<String, String> result = new HashMap<String, String>(params.length);
        for (String p : params) {
            String[] kv = p.split("=");
            result.put(PercentEncoding.decode(kv[0]), PercentEncoding.decode(kv[1]));
        }
        return result;
    }

    private String makeSignature(String method, URL url, Map<String, String> authParams, Token token) {
        StringBuilder sb = new StringBuilder(method + "&" + PercentEncoding.encode(OAuth1.makeBaseUri(url) + url.getPath()));
        List<String> params = OAuth1.splitAndEncodeParams(url);
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            params.add(PercentEncoding.encode(entry.getKey()) + "=" + PercentEncoding.encode(entry.getValue()));
        }
        Collections.sort(params);
        StringBuilder pb = new StringBuilder();
        for (String p : params) {
            if (pb.length() > 0) {
                pb.append("&");
            }
            pb.append(p);
        }
        sb.append("&");
        sb.append(PercentEncoding.encode(pb.toString()));
        String string = sb.toString();
        String tokenSecret = token != null ? token.getSecret() : "";
        String key = PercentEncoding.encode(this.consumerSecret) + "&" + PercentEncoding.encode(tokenSecret);
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(UTF8), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(secretKey);
            byte[] bytes = mac.doFinal(string.getBytes(UTF8));
            return PercentEncoding.encode(DatatypeConverter.printBase64Binary((byte[])bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }
}

