/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind.monadic;

import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.FlatMapBindingBase;
import org.fxmisc.easybind.monadic.PropertyBinding;

class FlatMapProperty<T, U>
extends FlatMapBindingBase<T, U, Property<U>>
implements PropertyBinding<U> {
    private ObservableValue<? extends U> boundTo = null;
    private boolean resetOnUnbind = false;
    private U resetTo = null;

    public FlatMapProperty(ObservableValue<T> src, Function<? super T, Property<U>> f) {
        super(src, f);
    }

    @Override
    protected Subscription observeTargetObservable(Property<U> mapped) {
        if (this.boundTo != null) {
            mapped.bind(this.boundTo);
        }
        Subscription s1 = super.observeTargetObservable(mapped);
        Subscription s2 = () -> {
            if (this.boundTo != null) {
                mapped.unbind();
                if (this.resetOnUnbind) {
                    mapped.setValue(this.resetTo);
                }
            }
        };
        return s1.and(s2);
    }

    @Override
    protected void srcInvalidated() {
        super.srcInvalidated();
        if (this.boundTo != null) {
            this.getTargetObservable();
        }
    }

    public void setValue(U value) {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.setValue(value);
        }
    }

    public void bind(ObservableValue<? extends U> other) {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.bind(other);
        }
        this.boundTo = other;
        this.resetOnUnbind = false;
        this.resetTo = null;
    }

    @Override
    public void bind(ObservableValue<? extends U> other, U resetToOnUnbind) {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.bind(other);
        }
        this.boundTo = other;
        this.resetOnUnbind = true;
        this.resetTo = resetToOnUnbind;
    }

    public boolean isBound() {
        return this.boundTo != null || this.getTargetObservable() != null && ((Property)this.getTargetObservable()).isBound();
    }

    public void unbind() {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.unbind();
        }
        this.boundTo = null;
    }

    public void bindBidirectional(Property<U> other) {
        Bindings.bindBidirectional((Property)this, other);
    }

    public void unbindBidirectional(Property<U> other) {
        Bindings.unbindBidirectional((Property)this, other);
    }

    public Object getBean() {
        return null;
    }

    public String getName() {
        return null;
    }
}

