/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Optional;
import org.fxmisc.richtext.model.SegmentOps;

public abstract class SegmentOpsBase<SEG, S>
implements SegmentOps<SEG, S> {
    private final SEG empty;

    public SegmentOpsBase(SEG emptySeg) {
        this.empty = emptySeg;
    }

    @Override
    public final char charAt(SEG seg, int index) {
        return this.length(seg) == 0 ? (char)'\u0000' : this.realCharAt(seg, index);
    }

    public abstract char realCharAt(SEG var1, int var2);

    @Override
    public final String getText(SEG seg) {
        return this.length(seg) == 0 ? "" : this.realGetText(seg);
    }

    public abstract String realGetText(SEG var1);

    @Override
    public final SEG subSequence(SEG seg, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Start cannot be negative. Start=" + start);
        }
        if (end > this.length(seg)) {
            throw new IllegalArgumentException(String.format("End cannot be greater than segment's length. End=%s Length=%s", end, this.length(seg)));
        }
        return this.length(seg) == 0 || start == end ? this.empty : this.realSubSequence(seg, start, end);
    }

    public abstract SEG realSubSequence(SEG var1, int var2, int var3);

    @Override
    public final SEG subSequence(SEG seg, int start) {
        return this.length(seg) == 0 || start == this.length(seg) ? this.empty : this.realSubSequence(seg, start);
    }

    public SEG realSubSequence(SEG seg, int start) {
        return this.realSubSequence(seg, start, this.length(seg));
    }

    @Override
    public final SEG createEmptySeg() {
        return this.empty;
    }

    @Override
    public Optional<S> joinStyle(S currentStyle, S nextStyle) {
        return Optional.empty();
    }
}

