/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jabref.JabRefExecutorService;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.DuplicateResolverDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertEntry;
import org.jabref.gui.undo.UndoableRemoveEntry;
import org.jabref.gui.worker.CallBack;
import org.jabref.logic.bibtex.DuplicateCheck;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import spin.Spin;

public class DuplicateSearch
implements Runnable {
    private final BasePanel panel;
    private List<BibEntry> bes;
    private final List<List<BibEntry>> duplicates = new ArrayList<List<BibEntry>>();

    public DuplicateSearch(BasePanel bp) {
        this.panel = bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.panel.output(Localization.lang("Searching for duplicates...", new String[0]));
        this.bes = this.panel.getDatabase().getEntries();
        if (this.bes.size() < 2) {
            return;
        }
        SearcherRunnable st = new SearcherRunnable();
        JabRefExecutorService.INSTANCE.executeInterruptableTask(st, "DuplicateSearcher");
        int current = 0;
        final ArrayList<BibEntry> toRemove = new ArrayList<BibEntry>();
        final ArrayList<BibEntry> toAdd = new ArrayList<BibEntry>();
        int duplicateCounter = 0;
        boolean autoRemoveExactDuplicates = false;
        List<List<BibEntry>> list = this.duplicates;
        synchronized (list) {
            while (!st.finished() || current < this.duplicates.size()) {
                if (current >= this.duplicates.size()) {
                    try {
                        this.duplicates.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                List<BibEntry> be = this.duplicates.get(current);
                ++current;
                if (toRemove.contains(be.get(0)) || toRemove.contains(be.get(1))) continue;
                boolean askAboutExact = false;
                if (DuplicateCheck.compareEntriesStrictly(be.get(0), be.get(1)) > 1.0) {
                    if (autoRemoveExactDuplicates) {
                        toRemove.add(be.get(1));
                        ++duplicateCounter;
                        continue;
                    }
                    askAboutExact = true;
                }
                DuplicateCallBack cb = new DuplicateCallBack(JabRefGUI.getMainFrame(), be.get(0), be.get(1), askAboutExact ? DuplicateResolverDialog.DuplicateResolverType.DUPLICATE_SEARCH_WITH_EXACT : DuplicateResolverDialog.DuplicateResolverType.DUPLICATE_SEARCH);
                ((CallBack)Spin.over(cb)).update();
                ++duplicateCounter;
                DuplicateResolverDialog.DuplicateResolverResult answer = cb.getSelected();
                if (answer == DuplicateResolverDialog.DuplicateResolverResult.KEEP_LEFT || answer == DuplicateResolverDialog.DuplicateResolverResult.AUTOREMOVE_EXACT) {
                    toRemove.add(be.get(1));
                    if (answer != DuplicateResolverDialog.DuplicateResolverResult.AUTOREMOVE_EXACT) continue;
                    autoRemoveExactDuplicates = true;
                    continue;
                }
                if (answer == DuplicateResolverDialog.DuplicateResolverResult.KEEP_RIGHT) {
                    toRemove.add(be.get(0));
                    continue;
                }
                if (answer == DuplicateResolverDialog.DuplicateResolverResult.BREAK) {
                    st.setFinished();
                    current = Integer.MAX_VALUE;
                    --duplicateCounter;
                    continue;
                }
                if (answer != DuplicateResolverDialog.DuplicateResolverResult.KEEP_MERGE) continue;
                toRemove.addAll(be);
                toAdd.add(cb.getMergedEntry());
            }
        }
        final NamedCompound ce = new NamedCompound(Localization.lang("duplicate removal", new String[0]));
        final int dupliC = duplicateCounter;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!toRemove.isEmpty()) {
                    for (BibEntry entry : toRemove) {
                        DuplicateSearch.this.panel.getDatabase().removeEntry(entry);
                        ce.addEdit(new UndoableRemoveEntry(DuplicateSearch.this.panel.getDatabase(), entry, DuplicateSearch.this.panel));
                    }
                    DuplicateSearch.this.panel.markBaseChanged();
                }
                if (!toAdd.isEmpty()) {
                    for (BibEntry entry : toAdd) {
                        DuplicateSearch.this.panel.getDatabase().insertEntry(entry);
                        ce.addEdit(new UndoableInsertEntry(DuplicateSearch.this.panel.getDatabase(), entry, DuplicateSearch.this.panel));
                    }
                    DuplicateSearch.this.panel.markBaseChanged();
                }
                List list = DuplicateSearch.this.duplicates;
                synchronized (list) {
                    DuplicateSearch.this.panel.output(Localization.lang("Duplicates found", new String[0]) + ": " + DuplicateSearch.this.duplicates.size() + ' ' + Localization.lang("pairs processed", new String[0]) + ": " + dupliC);
                }
                ce.end();
                DuplicateSearch.this.panel.getUndoManager().addEdit(ce);
            }
        });
    }

    static class DuplicateCallBack
    implements CallBack {
        private DuplicateResolverDialog.DuplicateResolverResult reply = DuplicateResolverDialog.DuplicateResolverResult.NOT_CHOSEN;
        private final JabRefFrame frame;
        private final BibEntry one;
        private final BibEntry two;
        private final DuplicateResolverDialog.DuplicateResolverType dialogType;
        private BibEntry merged;

        public DuplicateCallBack(JabRefFrame frame, BibEntry one, BibEntry two, DuplicateResolverDialog.DuplicateResolverType dialogType) {
            this.frame = frame;
            this.one = one;
            this.two = two;
            this.dialogType = dialogType;
        }

        public DuplicateResolverDialog.DuplicateResolverResult getSelected() {
            return this.reply;
        }

        public BibEntry getMergedEntry() {
            return this.merged;
        }

        @Override
        public void update() {
            DuplicateResolverDialog diag = new DuplicateResolverDialog(this.frame, this.one, this.two, this.dialogType);
            diag.setVisible(true);
            diag.dispose();
            this.reply = diag.getSelected();
            this.merged = diag.getMergedEntry();
        }
    }

    class SearcherRunnable
    implements Runnable {
        private volatile boolean finished;

        SearcherRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < DuplicateSearch.this.bes.size() - 1 && !this.finished; ++i) {
                for (int j = i + 1; j < DuplicateSearch.this.bes.size() && !this.finished; ++j) {
                    BibEntry second;
                    BibEntry first = (BibEntry)DuplicateSearch.this.bes.get(i);
                    boolean eq2 = DuplicateCheck.isDuplicate(first, second = (BibEntry)DuplicateSearch.this.bes.get(j), DuplicateSearch.this.panel.getBibDatabaseContext().getMode());
                    if (!eq2) continue;
                    List list = DuplicateSearch.this.duplicates;
                    synchronized (list) {
                        DuplicateSearch.this.duplicates.add(Arrays.asList(first, second));
                        DuplicateSearch.this.duplicates.notifyAll();
                        continue;
                    }
                }
            }
            this.finished = true;
            List list = DuplicateSearch.this.duplicates;
            synchronized (list) {
                DuplicateSearch.this.duplicates.notifyAll();
            }
        }

        public boolean finished() {
            return this.finished;
        }

        public void setFinished() {
            this.finished = true;
        }
    }
}

