/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.bibtex.DuplicateCheck;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BiblatexEntryTypes;
import org.jabref.model.entry.BibtexEntryTypes;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.IEEETranEntryTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryTypeDialog
extends JabRefDialog
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryTypeDialog.class);
    private static final int COLUMN = 3;
    private final JabRefFrame frame;
    private final CancelAction cancelAction = new CancelAction();
    private EntryType type;
    private SwingWorker<Optional<BibEntry>, Void> fetcherWorker = new FetcherWorker();
    private JButton generateButton;
    private JTextField idTextField;
    private JComboBox<String> comboBox;

    public EntryTypeDialog(JabRefFrame frame) {
        super((Frame)frame, true, EntryTypeDialog.class);
        this.frame = frame;
        this.setTitle(Localization.lang("Select entry type", new String[0]));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EntryTypeDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createCancelButtonBarPanel(), "South");
        this.getContentPane().add((Component)this.createEntryGroupsPanel(), "Center");
        this.pack();
        this.setResizable(false);
    }

    private JPanel createEntryGroupsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (this.frame.getCurrentBasePanel().getBibDatabaseContext().isBiblatexMode()) {
            panel.add(this.createEntryGroupPanel("biblatex", BiblatexEntryTypes.ALL));
            List<EntryType> customTypes = EntryTypes.getAllCustomTypes(BibDatabaseMode.BIBLATEX);
            if (!customTypes.isEmpty()) {
                panel.add(this.createEntryGroupPanel(Localization.lang("Custom", new String[0]), customTypes));
            }
        } else {
            panel.add(this.createEntryGroupPanel("BibTeX", BibtexEntryTypes.ALL));
            panel.add(this.createEntryGroupPanel("IEEETran", IEEETranEntryTypes.ALL));
            List<EntryType> customTypes = EntryTypes.getAllCustomTypes(BibDatabaseMode.BIBTEX);
            if (!customTypes.isEmpty()) {
                panel.add(this.createEntryGroupPanel(Localization.lang("Custom", new String[0]), customTypes));
            }
        }
        panel.add(this.createIdFetcherPanel());
        return panel;
    }

    private JPanel createCancelButtonBarPanel() {
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(this);
        cancel.getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        cancel.getActionMap().put("close", this.cancelAction);
        JPanel buttons = new JPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        bb.addGlue();
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        return buttons;
    }

    private JPanel createEntryGroupPanel(String groupTitle, Collection<? extends EntryType> entries) {
        JPanel panel = new JPanel();
        GridBagLayout bagLayout = new GridBagLayout();
        panel.setLayout(bagLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(4, 4, 4, 4);
        int col = 0;
        for (EntryType entryType : entries) {
            TypeButton entryButton = new TypeButton(entryType.getName(), entryType);
            entryButton.addActionListener(this);
            if (++col == 3) {
                col = 0;
                constraints.gridwidth = 0;
            } else {
                constraints.gridwidth = 1;
            }
            bagLayout.setConstraints(entryButton, constraints);
            panel.add(entryButton);
        }
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), groupTitle));
        return panel;
    }

    private JPanel createIdFetcherPanel() {
        JLabel fetcherLabel = new JLabel(Localization.lang("ID type", new String[0]));
        JLabel idLabel = new JLabel(Localization.lang("ID", new String[0]));
        this.generateButton = new JButton(Localization.lang("Generate", new String[0]));
        this.idTextField = new JTextField("");
        this.comboBox = new JComboBox();
        WebFetchers.getIdBasedFetchers(Globals.prefs.getImportFormatPreferences()).forEach(fetcher -> this.comboBox.addItem(fetcher.getName()));
        this.comboBox.setSelectedItem(Globals.prefs.get("idEntryGenerator"));
        this.generateButton.addActionListener(action -> this.fetcherWorker.execute());
        this.comboBox.addActionListener(e -> {
            this.idTextField.requestFocus();
            this.idTextField.selectAll();
        });
        this.idTextField.addActionListener(event -> this.fetcherWorker.execute());
        JPanel jPanel = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(4, 4, 4, 4);
        GridBagLayout layout = new GridBagLayout();
        jPanel.setLayout(layout);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        jPanel.add((Component)fetcherLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 2.0;
        jPanel.add(this.comboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        jPanel.add((Component)idLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 2.0;
        jPanel.add((Component)this.idTextField, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        jPanel.add((Component)this.generateButton, constraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("ID-based entry generator", new String[0])));
        SwingUtilities.invokeLater(() -> this.idTextField.requestFocus());
        return jPanel;
    }

    private void stopFetching() {
        if (this.fetcherWorker.getState() == SwingWorker.StateValue.STARTED) {
            this.fetcherWorker.cancel(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof TypeButton) {
            this.type = ((TypeButton)e.getSource()).getType();
        }
        this.stopFetching();
        this.dispose();
    }

    public EntryType getChoice() {
        return this.type;
    }

    private class FetcherWorker
    extends SwingWorker<Optional<BibEntry>, Void> {
        private boolean fetcherException = false;
        private String fetcherExceptionMessage = "";
        private IdBasedFetcher fetcher = null;
        private String searchID = "";

        private FetcherWorker() {
        }

        @Override
        protected Optional<BibEntry> doInBackground() throws Exception {
            Optional<BibEntry> bibEntry = Optional.empty();
            SwingUtilities.invokeLater(() -> {
                EntryTypeDialog.this.generateButton.setEnabled(false);
                EntryTypeDialog.this.generateButton.setText(Localization.lang("Searching...", new String[0]));
            });
            Globals.prefs.put("idEntryGenerator", String.valueOf(EntryTypeDialog.this.comboBox.getSelectedItem()));
            this.fetcher = WebFetchers.getIdBasedFetchers(Globals.prefs.getImportFormatPreferences()).get(EntryTypeDialog.this.comboBox.getSelectedIndex());
            this.searchID = EntryTypeDialog.this.idTextField.getText();
            if (!this.searchID.isEmpty()) {
                try {
                    bibEntry = this.fetcher.performSearchById(this.searchID);
                }
                catch (FetcherException e) {
                    LOGGER.error(e.getMessage(), e);
                    this.fetcherException = true;
                    this.fetcherExceptionMessage = e.getMessage();
                }
            }
            return bibEntry;
        }

        @Override
        protected void done() {
            try {
                Optional result = (Optional)this.get();
                if (result.isPresent()) {
                    BibEntry bibEntry = (BibEntry)result.get();
                    if (DuplicateCheck.containsDuplicate(EntryTypeDialog.this.frame.getCurrentBasePanel().getDatabase(), bibEntry, EntryTypeDialog.this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode()).isPresent()) {
                        BasePanel panel = (BasePanel)EntryTypeDialog.this.frame.getTabbedPane().getSelectedComponent();
                        ImportInspectionDialog diag = new ImportInspectionDialog(EntryTypeDialog.this.frame, panel, Localization.lang("Import", new String[0]), false);
                        diag.addEntry(bibEntry);
                        diag.entryListComplete();
                        diag.setLocationRelativeTo(EntryTypeDialog.this.frame);
                        diag.setVisible(true);
                        diag.toFront();
                    } else {
                        new BibtexKeyGenerator(EntryTypeDialog.this.frame.getCurrentBasePanel().getBibDatabaseContext(), Globals.prefs.getBibtexKeyPatternPreferences()).generateAndSetKey(bibEntry);
                        if (Globals.prefs.getTimestampPreferences().includeCreatedTimestamp()) {
                            bibEntry.setField(Globals.prefs.getTimestampPreferences().getTimestampField(), Globals.prefs.getTimestampPreferences().now());
                        }
                        EntryTypeDialog.this.frame.getCurrentBasePanel().insertEntry(bibEntry);
                    }
                    EntryTypeDialog.this.dispose();
                } else if (this.searchID.trim().isEmpty()) {
                    JOptionPane.showMessageDialog(EntryTypeDialog.this.frame, Localization.lang("The given search ID was empty.", new String[0]), Localization.lang("Empty search ID", new String[0]), 2);
                } else if (!this.fetcherException) {
                    JOptionPane.showMessageDialog(EntryTypeDialog.this.frame, Localization.lang("Fetcher '%0' did not find an entry for id '%1'.", this.fetcher.getName(), this.searchID) + "\n" + this.fetcherExceptionMessage, Localization.lang("No files found.", new String[0]), 2);
                } else {
                    JOptionPane.showMessageDialog(EntryTypeDialog.this.frame, Localization.lang("Error while fetching from %0", this.fetcher.getName()) + ".\n" + this.fetcherExceptionMessage, Localization.lang("Error", new String[0]), 0);
                }
                EntryTypeDialog.this.fetcherWorker = new FetcherWorker();
                SwingUtilities.invokeLater(() -> {
                    EntryTypeDialog.this.idTextField.requestFocus();
                    EntryTypeDialog.this.idTextField.selectAll();
                    EntryTypeDialog.this.generateButton.setText(Localization.lang("Generate", new String[0]));
                    EntryTypeDialog.this.generateButton.setEnabled(true);
                });
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(String.format("Exception during fetching when using fetcher '%s' with entry id '%s'.", this.searchID, this.fetcher.getName()), e);
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryTypeDialog.this.stopFetching();
            EntryTypeDialog.this.dispose();
        }
    }

    static class TypeButton
    extends JButton
    implements Comparable<TypeButton> {
        private final EntryType type;

        TypeButton(String label, EntryType type) {
            super(label);
            this.type = type;
        }

        @Override
        public int compareTo(TypeButton o) {
            return this.type.getName().compareTo(o.type.getName());
        }

        public EntryType getType() {
            return this.type;
        }
    }
}

