/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.event.ActionEvent;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.worker.LookupIdentifiersWorker;
import org.jabref.logic.importer.IdFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupIdentifierAction
extends MnemonicAwareAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookupIdentifierAction.class);
    private final JabRefFrame frame;
    private final IdFetcher fetcher;

    public LookupIdentifierAction(JabRefFrame frame, IdFetcher fetcher) {
        this.frame = frame;
        this.fetcher = fetcher;
        this.putValue("Name", fetcher.getIdentifierName());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            BasePanel.runWorker(new LookupIdentifiersWorker(this.frame, this.fetcher));
        }
        catch (Exception e) {
            LOGGER.error("Problem running ID Worker", e);
        }
    }
}

