/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.event.ActionEvent;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.Defaults;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;

public class NewDatabaseAction
extends MnemonicAwareAction {
    private final JabRefFrame jabRefFrame;
    private final BibDatabaseMode mode;

    public NewDatabaseAction(JabRefFrame jabRefFrame, BibDatabaseMode mode) {
        super(IconTheme.JabRefIcon.NEW.getIcon());
        this.jabRefFrame = jabRefFrame;
        this.mode = mode;
        this.putValue("Name", Localization.menuTitle("New %0 library", mode.getFormattedName()));
        this.putValue("ShortDescription", Localization.lang("New %0 library", mode.getFormattedName()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BibDatabaseContext bibDatabaseContext = new BibDatabaseContext(new Defaults(BibDatabaseMode.BIBTEX));
        bibDatabaseContext.setMode(this.mode);
        this.jabRefFrame.addTab(bibDatabaseContext, true);
        this.jabRefFrame.output(Localization.lang("New %0 library created.", this.mode.getFormattedName()));
    }
}

