/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.cleanup.CleanupActionsListModel;
import org.jabref.logic.cleanup.Cleanups;
import org.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.cleanup.FieldFormatterCleanups;
import org.jabref.model.cleanup.Formatter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.metadata.MetaData;

public class FieldFormatterCleanupsPanel
extends JPanel {
    private static final String DESCRIPTION = Localization.lang("Description", new String[0]) + ": ";
    private final JCheckBox cleanupEnabled;
    private FieldFormatterCleanups fieldFormatterCleanups;
    private JList<?> actionsList;
    private JComboBox<?> formattersCombobox;
    private JComboBox<String> selectFieldCombobox;
    private JButton addButton;
    private JTextArea descriptionAreaText;
    private JButton removeButton;
    private JButton resetButton;
    private JButton recommendButton;
    private final FieldFormatterCleanups defaultFormatters;
    private List<Formatter> availableFormatters;

    public FieldFormatterCleanupsPanel(String description, FieldFormatterCleanups defaultFormatters) {
        this.defaultFormatters = Objects.requireNonNull(defaultFormatters);
        this.cleanupEnabled = new JCheckBox(description);
        this.availableFormatters = Cleanups.getBuiltInFormatters();
        this.availableFormatters.add(new ProtectTermsFormatter(Globals.protectedTermsLoader));
    }

    public void setValues(MetaData metaData) {
        Objects.requireNonNull(metaData);
        Optional<FieldFormatterCleanups> saveActions = metaData.getSaveActions();
        this.setValues(saveActions.orElse(Cleanups.DEFAULT_SAVE_ACTIONS));
    }

    public void setValues(FieldFormatterCleanups formatterCleanups) {
        this.fieldFormatterCleanups = formatterCleanups;
        this.removeAll();
        List<FieldFormatterCleanup> configuredActions = this.fieldFormatterCleanups.getConfiguredActions();
        ArrayList<FieldFormatterCleanup> actionsToDisplay = new ArrayList<FieldFormatterCleanup>(configuredActions);
        this.buildLayout(actionsToDisplay);
    }

    private void buildLayout(List<FieldFormatterCleanup> actionsToDisplay) {
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 13dlu, left:pref:grow, 4dlu, pref, 4dlu, pref", "pref, 2dlu, pref, 2dlu, pref, 4dlu, pref, 2dlu, fill:pref:grow, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu"));
        builder.add(this.cleanupEnabled).xyw(1, 1, 7);
        this.actionsList = new JList<FieldFormatterCleanup>(new CleanupActionsListModel(actionsToDisplay));
        this.actionsList.setSelectionMode(0);
        this.actionsList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                CleanupActionsListModel m3 = (CleanupActionsListModel)FieldFormatterCleanupsPanel.this.actionsList.getModel();
                int index = FieldFormatterCleanupsPanel.this.actionsList.locationToIndex(e.getPoint());
                if (index > -1) {
                    FieldFormatterCleanupsPanel.this.actionsList.setToolTipText(m3.getElementAt(index).getFormatter().getDescription());
                }
            }
        });
        this.actionsList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (e.getIndex0() == 0) {
                    FieldFormatterCleanupsPanel.this.actionsList.setSelectedIndex(e.getIndex0());
                }
                if (e.getIndex0() > 0) {
                    FieldFormatterCleanupsPanel.this.actionsList.setSelectedIndex(e.getIndex0() - 1);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        builder.add(this.actionsList).xyw(3, 5, 5);
        this.resetButton = new JButton(Localization.lang("Reset", new String[0]));
        this.resetButton.addActionListener(e -> ((CleanupActionsListModel)this.actionsList.getModel()).reset(this.defaultFormatters));
        BibDatabaseContext databaseContext = JabRefGUI.getMainFrame().getCurrentBasePanel().getBibDatabaseContext();
        this.recommendButton = new JButton(Localization.lang("Recommended for %0", databaseContext.getMode().getFormattedName()));
        boolean isBiblatex = databaseContext.isBiblatexMode();
        this.recommendButton.addActionListener(e -> {
            if (isBiblatex) {
                ((CleanupActionsListModel)this.actionsList.getModel()).reset(Cleanups.RECOMMEND_BIBLATEX_ACTIONS);
            } else {
                ((CleanupActionsListModel)this.actionsList.getModel()).reset(Cleanups.RECOMMEND_BIBTEX_ACTIONS);
            }
        });
        this.removeButton = new JButton(Localization.lang("Remove selected", new String[0]));
        this.removeButton.addActionListener(e -> ((CleanupActionsListModel)this.actionsList.getModel()).removeAtIndex(this.actionsList.getSelectedIndex()));
        builder.add(this.removeButton).xy(7, 11);
        builder.add(this.resetButton).xy(3, 11);
        builder.add(this.recommendButton).xy(5, 11);
        builder.add(this.getSelectorPanel()).xyw(3, 15, 5);
        this.makeDescriptionTextAreaLikeJLabel();
        builder.add(this.descriptionAreaText).xyw(3, 17, 5);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "West");
        this.updateDescription();
        this.cleanupEnabled.addActionListener(new EnablementStatusListener(this.fieldFormatterCleanups.isEnabled()));
        this.cleanupEnabled.setSelected(this.fieldFormatterCleanups.isEnabled());
    }

    private void makeDescriptionTextAreaLikeJLabel() {
        this.descriptionAreaText = new JTextArea(DESCRIPTION);
        this.descriptionAreaText.setLineWrap(true);
        this.descriptionAreaText.setWrapStyleWord(true);
        this.descriptionAreaText.setColumns(6);
        this.descriptionAreaText.setEditable(false);
        this.descriptionAreaText.setOpaque(false);
        this.descriptionAreaText.setFocusable(false);
        this.descriptionAreaText.setCursor(null);
        this.descriptionAreaText.setFont(UIManager.getFont("Label.font"));
    }

    private void updateDescription() {
        FieldFormatterCleanup formatterCleanup = this.getFieldFormatterCleanup();
        if (formatterCleanup != null) {
            this.descriptionAreaText.setText(DESCRIPTION + formatterCleanup.getFormatter().getDescription());
        } else {
            Formatter selectedFormatter = this.getFieldFormatter();
            if (selectedFormatter != null) {
                this.descriptionAreaText.setText(DESCRIPTION + selectedFormatter.getDescription());
            } else {
                this.descriptionAreaText.setText(DESCRIPTION);
            }
        }
    }

    private JPanel getSelectorPanel() {
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref:grow, 4dlu, left:pref:grow, 4dlu, fill:pref:grow, 4dlu, right:pref", "fill:pref:grow, 2dlu, pref, 2dlu"));
        List<String> fieldNames = InternalBibtexFields.getAllPublicAndInternalFieldNames();
        fieldNames.add("bibtexkey");
        Collections.sort(fieldNames);
        String[] allPlusKey = fieldNames.toArray(new String[fieldNames.size()]);
        this.selectFieldCombobox = new JComboBox<String>(allPlusKey);
        this.selectFieldCombobox.setEditable(true);
        builder.add(this.selectFieldCombobox).xy(1, 1);
        List formatterNames = this.availableFormatters.stream().map(Formatter::getName).collect(Collectors.toList());
        final List formatterDescriptions = this.availableFormatters.stream().map(Formatter::getDescription).collect(Collectors.toList());
        this.formattersCombobox = new JComboBox<Object>(formatterNames.toArray());
        this.formattersCombobox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (-1 < index && index < formatterDescriptions.size() && value != null) {
                    this.setToolTipText((String)formatterDescriptions.get(index));
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.formattersCombobox.addItemListener(e -> this.updateDescription());
        builder.add(this.formattersCombobox).xy(3, 1);
        this.addButton = new JButton(Localization.lang("Add", new String[0]));
        this.addButton.addActionListener(e -> {
            FieldFormatterCleanup newAction = this.getFieldFormatterCleanup();
            if (newAction == null) {
                return;
            }
            ((CleanupActionsListModel)this.actionsList.getModel()).addCleanupAction(newAction);
        });
        builder.add(this.addButton).xy(5, 1);
        return builder.getPanel();
    }

    public void storeSettings(MetaData metaData) {
        Objects.requireNonNull(metaData);
        FieldFormatterCleanups formatterCleanups = this.getFormatterCleanups();
        if (formatterCleanups.getConfiguredActions().isEmpty()) {
            metaData.clearSaveActions();
            return;
        }
        metaData.setSaveActions(formatterCleanups);
    }

    public FieldFormatterCleanups getFormatterCleanups() {
        List<FieldFormatterCleanup> actions2 = ((CleanupActionsListModel)this.actionsList.getModel()).getAllActions();
        return new FieldFormatterCleanups(this.cleanupEnabled.isSelected(), actions2);
    }

    public boolean hasChanged() {
        return !this.fieldFormatterCleanups.equals(this.getFormatterCleanups());
    }

    public boolean isDefaultSaveActions() {
        return Cleanups.DEFAULT_SAVE_ACTIONS.equals(this.getFormatterCleanups());
    }

    private FieldFormatterCleanup getFieldFormatterCleanup() {
        Formatter selectedFormatter = this.getFieldFormatter();
        String fieldKey = this.selectFieldCombobox.getSelectedItem().toString();
        return new FieldFormatterCleanup(fieldKey, selectedFormatter);
    }

    private Formatter getFieldFormatter() {
        Formatter selectedFormatter = null;
        String selectedFormatterName = this.formattersCombobox.getSelectedItem().toString();
        for (Formatter formatter : this.availableFormatters) {
            if (!formatter.getName().equals(selectedFormatterName)) continue;
            selectedFormatter = formatter;
            break;
        }
        return selectedFormatter;
    }

    class EnablementStatusListener
    implements ActionListener {
        public EnablementStatusListener(boolean initialStatus) {
            this.setStatus(initialStatus);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean enablementStatus = FieldFormatterCleanupsPanel.this.cleanupEnabled.isSelected();
            this.setStatus(enablementStatus);
        }

        private void setStatus(boolean status) {
            FieldFormatterCleanupsPanel.this.actionsList.setEnabled(status);
            FieldFormatterCleanupsPanel.this.selectFieldCombobox.setEnabled(status);
            FieldFormatterCleanupsPanel.this.formattersCombobox.setEnabled(status);
            FieldFormatterCleanupsPanel.this.addButton.setEnabled(status);
            FieldFormatterCleanupsPanel.this.removeButton.setEnabled(status);
            FieldFormatterCleanupsPanel.this.resetButton.setEnabled(status);
            FieldFormatterCleanupsPanel.this.recommendButton.setEnabled(status);
        }
    }
}

