/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;

class ChangeDisplayDialog
extends JabRefDialog
implements TreeSelectionListener {
    private final JTree tree;
    private final JPanel infoPanel = new JPanel();
    private final JCheckBox cb = new JCheckBox(Localization.lang("Accept change", new String[0]));
    private final JLabel rootInfo = new JLabel(Localization.lang("Select the tree nodes to view and accept or reject changes", new String[0]) + '.');
    private ChangeViewModel selected;
    private JComponent infoShown;
    private boolean okPressed;

    public ChangeDisplayDialog(JFrame owner, BasePanel panel, BibDatabase secondary, DefaultMutableTreeNode root) {
        super((Frame)owner, Localization.lang("External changes", new String[0]), true, ChangeDisplayDialog.class);
        BibDatabase localSecondary = secondary == null ? new BibDatabase() : secondary;
        this.tree = new JTree(root);
        this.tree.addTreeSelectionListener(this);
        JSplitPane pane = new JSplitPane();
        pane.setLeftComponent(new JScrollPane(this.tree));
        JPanel infoBorder = new JPanel();
        pane.setRightComponent(infoBorder);
        this.cb.setMargin(new Insets(2, 2, 2, 2));
        this.cb.setEnabled(false);
        this.infoPanel.setLayout(new BorderLayout());
        infoBorder.setLayout(new BorderLayout());
        infoBorder.setBorder(BorderFactory.createEtchedBorder());
        infoBorder.add((Component)this.infoPanel, "Center");
        this.setInfo(this.rootInfo);
        this.infoPanel.add((Component)this.cb, "South");
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(ok);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        buttonPanel.add(cancel);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.cb.addChangeListener(e -> {
            if (this.selected != null) {
                this.selected.setAccepted(this.cb.isSelected());
            }
        });
        cancel.addActionListener(e -> this.dispose());
        ok.addActionListener(e -> {
            NamedCompound ce = new NamedCompound(Localization.lang("Merged external changes", new String[0]));
            Enumeration<TreeNode> enumer = root.children();
            boolean anyDisabled = false;
            for (ChangeViewModel changeViewModel : Collections.list(enumer)) {
                boolean allAccepted = false;
                if (changeViewModel.isAcceptable() && changeViewModel.isAccepted()) {
                    allAccepted = changeViewModel.makeChange(panel, localSecondary, ce);
                }
                if (allAccepted) continue;
                anyDisabled = true;
            }
            ce.end();
            panel.getUndoManager().addEdit(ce);
            if (anyDisabled) {
                panel.markBaseChanged();
            }
            panel.markExternalChangesAsResolved();
            this.dispose();
            this.okPressed = true;
        });
        this.pack();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void setInfo(JComponent comp) {
        if (this.infoShown != null) {
            this.infoPanel.remove(this.infoShown);
        }
        this.infoShown = comp;
        this.infoPanel.add((Component)this.infoShown, "Center");
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o instanceof ChangeViewModel) {
            this.selected = (ChangeViewModel)o;
            this.setInfo(this.selected.description());
            this.cb.setSelected(this.selected.isAccepted());
            this.cb.setEnabled(this.selected.isAcceptable());
        } else {
            this.setInfo(this.rootInfo);
            this.selected = null;
            this.cb.setEnabled(false);
        }
    }
}

