/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import org.jabref.gui.BasePanel;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableRemoveEntry;
import org.jabref.logic.bibtex.DuplicateCheck;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntryDeleteChangeViewModel
extends ChangeViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryDeleteChangeViewModel.class);
    private final BibEntry memEntry;
    private final BibEntry tmpEntry;
    private final JFXPanel container;

    public EntryDeleteChangeViewModel(BibEntry memEntry, BibEntry tmpEntry) {
        super(Localization.lang("Deleted entry", new String[0]));
        this.memEntry = memEntry;
        this.tmpEntry = tmpEntry;
        double matchWithTmp = DuplicateCheck.compareEntriesStrictly(memEntry, tmpEntry);
        boolean isModifiedLocally = matchWithTmp <= 1.0;
        LOGGER.debug("Modified entry: " + memEntry.getCiteKeyOptional().orElse("<no BibTeX key set>") + "\n Modified locally: " + isModifiedLocally);
        PreviewPanel previewPanel = new PreviewPanel(null, null);
        previewPanel.setEntry(memEntry);
        this.container = CustomJFXPanel.wrap(new Scene((Parent)previewPanel));
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        panel.getDatabase().removeEntry(this.memEntry);
        undoEdit.addEdit(new UndoableRemoveEntry(panel.getDatabase(), this.memEntry, panel));
        secondary.removeEntry(this.tmpEntry);
        return true;
    }

    @Override
    public JComponent description() {
        return this.container;
    }
}

