/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.copyfiles;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javafx.concurrent.Task;
import javax.swing.AbstractAction;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.DialogService;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.copyfiles.CopyFilesDialogView;
import org.jabref.gui.copyfiles.CopyFilesResultItemViewModel;
import org.jabref.gui.copyfiles.CopyFilesResultListDependency;
import org.jabref.gui.copyfiles.CopyFilesTask;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public class CopyFilesAction
extends AbstractAction {
    private final DialogService dialogService = new FXDialogService();
    private BibDatabaseContext databaseContext;
    private List<BibEntry> entries;

    public CopyFilesAction() {
        super(Localization.lang("Copy linked files to folder...", new String[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(Paths.get(Globals.prefs.get("exportWorkingDirectory"), new String[0])).build();
        this.entries = JabRefGUI.getMainFrame().getCurrentBasePanel().getSelectedEntries();
        Optional exportPath = DefaultTaskExecutor.runInJavaFXThread(() -> this.dialogService.showDirectorySelectionDialog(dirDialogConfiguration));
        exportPath.ifPresent(path -> {
            this.databaseContext = JabRefGUI.getMainFrame().getCurrentBasePanel().getBibDatabaseContext();
            CopyFilesTask exportTask = new CopyFilesTask(this.databaseContext, this.entries, (Path)path);
            this.startServiceAndshowProgessDialog(exportTask);
        });
    }

    private void startServiceAndshowProgessDialog(Task<List<CopyFilesResultItemViewModel>> exportService) {
        DefaultTaskExecutor.runInJavaFXThread(() -> this.dialogService.showCanceableProgressDialogAndWait(exportService));
        exportService.run();
        DefaultTaskExecutor.runInJavaFXThread(() -> this.showDialog((List)exportService.getValue()));
    }

    private void showDialog(List<CopyFilesResultItemViewModel> data) {
        if (data.isEmpty()) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Copy linked files to folder...", new String[0]), Localization.lang("No linked files found for export.", new String[0]));
            return;
        }
        CopyFilesDialogView dlg = new CopyFilesDialogView(this.databaseContext, new CopyFilesResultListDependency(data));
        dlg.show();
    }
}

