/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.jabref.gui.AbstractController;
import org.jabref.gui.StateManager;
import org.jabref.gui.documentviewer.DocumentViewModel;
import org.jabref.gui.documentviewer.DocumentViewerControl;
import org.jabref.gui.documentviewer.DocumentViewerViewModel;
import org.jabref.gui.util.OnlyIntegerFormatter;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.model.entry.LinkedFile;

public class DocumentViewerController
extends AbstractController<DocumentViewerViewModel> {
    @FXML
    private ScrollBar scrollBar;
    @FXML
    private ComboBox<LinkedFile> fileChoice;
    @FXML
    private BorderPane mainPane;
    @FXML
    private ToggleButton modeLive;
    @FXML
    private TextField currentPage;
    @FXML
    private Label maxPages;
    @Inject
    private StateManager stateManager;
    @Inject
    private TaskExecutor taskExecutor;
    private DocumentViewerControl viewer;

    @FXML
    private void initialize() {
        this.viewModel = new DocumentViewerViewModel(this.stateManager);
        this.setupViewer();
        this.setupScrollbar();
        this.setupFileChoice();
        this.setupPageControls();
        this.setupModeButtons();
    }

    private void setupModeButtons() {
        ((DocumentViewerViewModel)this.viewModel).liveModeProperty().bind((ObservableValue)this.modeLive.selectedProperty());
    }

    private void setupScrollbar() {
        this.scrollBar.valueProperty().bindBidirectional((Property)this.viewer.scrollYProperty());
        this.scrollBar.maxProperty().bind((ObservableValue)this.viewer.scrollYMaxProperty());
    }

    private void setupPageControls() {
        OnlyIntegerFormatter integerFormatter = new OnlyIntegerFormatter(1);
        ((DocumentViewerViewModel)this.viewModel).currentPageProperty().bindBidirectional((Property)integerFormatter.valueProperty());
        this.currentPage.setTextFormatter((TextFormatter)integerFormatter);
        this.maxPages.textProperty().bind((ObservableValue)((DocumentViewerViewModel)this.viewModel).maxPagesProperty().asString());
    }

    private void setupFileChoice() {
        ViewModelListCellFactory cellFactory = new ViewModelListCellFactory().withText(LinkedFile::getLink);
        this.fileChoice.setButtonCell(cellFactory.call(null));
        this.fileChoice.setCellFactory(cellFactory);
        this.fileChoice.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> ((DocumentViewerViewModel)this.viewModel).switchToFile((LinkedFile)newValue));
        this.fileChoice.itemsProperty().addListener((observable, oldValue, newValue) -> this.fileChoice.getSelectionModel().selectFirst());
        this.fileChoice.itemsProperty().bind(((DocumentViewerViewModel)this.viewModel).filesProperty());
    }

    private void setupViewer() {
        this.viewer = new DocumentViewerControl(this.taskExecutor);
        ((DocumentViewerViewModel)this.viewModel).currentDocumentProperty().addListener((observable, oldDocument, newDocument) -> {
            if (newDocument != null) {
                this.viewer.show((DocumentViewModel)newDocument);
            }
        });
        ((DocumentViewerViewModel)this.viewModel).currentPageProperty().bindBidirectional(this.viewer.currentPageProperty());
        this.mainPane.setCenter((Node)this.viewer);
    }

    public void nextPage(ActionEvent actionEvent) {
        ((DocumentViewerViewModel)this.viewModel).showNextPage();
    }

    public void previousPage(ActionEvent actionEvent) {
        ((DocumentViewerViewModel)this.viewModel).showPreviousPage();
    }

    public void fitWidth(ActionEvent actionEvent) {
        this.viewer.setPageWidth(this.viewer.getWidth());
    }

    public void zoomIn(ActionEvent actionEvent) {
        this.viewer.changePageWidth(100);
    }

    public void zoomOut(ActionEvent actionEvent) {
        this.viewer.changePageWidth(-100);
    }

    public void fitSinglePage(ActionEvent actionEvent) {
        this.viewer.setPageHeight(this.viewer.getHeight());
    }
}

