/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import java.util.ArrayList;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.jabref.gui.documentviewer.DocumentPageViewModel;
import org.jabref.gui.documentviewer.DocumentViewModel;
import org.jabref.gui.documentviewer.PdfDocumentPageViewModel;

public class PdfDocumentViewModel
extends DocumentViewModel {
    private final PDDocument document;

    public PdfDocumentViewModel(PDDocument document) {
        this.document = Objects.requireNonNull(document);
        this.maxPagesProperty().set(document.getNumberOfPages());
    }

    @Override
    public ObservableList<DocumentPageViewModel> getPages() {
        PDPageTree pages = this.document.getDocumentCatalog().getPages();
        ArrayList<PdfDocumentPageViewModel> pdfPages = new ArrayList<PdfDocumentPageViewModel>();
        for (int i = 0; i < pages.getCount(); ++i) {
            pdfPages.add(new PdfDocumentPageViewModel(pages.get(i), i + 1, this.document));
        }
        return FXCollections.observableArrayList(pdfPages);
    }
}

