/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.xmp.XmpUtilWriter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class WriteXMPAction
extends AbstractWorker {
    private final BasePanel panel;
    private Collection<BibEntry> entries;
    private BibDatabase database;
    private OptionsDialog optDiag;
    private boolean goOn = true;
    private int skipped;
    private int entriesChanged;
    private int errors;

    public WriteXMPAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void init() {
        this.database = this.panel.getDatabase();
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.isEmpty()) {
            this.entries = this.database.getEntries();
            if (this.entries.isEmpty()) {
                JOptionPane.showMessageDialog(this.panel, Localization.lang("This operation requires one or more entries to be selected.", new String[0]), Localization.lang("Write XMP-metadata", new String[0]), 0);
                this.goOn = false;
                return;
            }
            int response = JOptionPane.showConfirmDialog(this.panel, Localization.lang("Write XMP-metadata for all PDFs in current library?", new String[0]), Localization.lang("Write XMP-metadata", new String[0]), 1, 3);
            if (response != 0) {
                this.goOn = false;
                return;
            }
        }
        this.skipped = 0;
        this.entriesChanged = 0;
        this.errors = 0;
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame());
        }
        this.optDiag.open();
        this.panel.output(Localization.lang("Writing XMP-metadata...", new String[0]));
    }

    @Override
    public void run() {
        if (!this.goOn) {
            return;
        }
        for (BibEntry entry : this.entries) {
            List files = entry.getFiles().stream().filter(file -> file.getFileType().equalsIgnoreCase("pdf")).map(file -> file.findIn(this.panel.getBibDatabaseContext(), Globals.prefs.getFileDirectoryPreferences())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append(entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0])) + "\n"));
            if (files.isEmpty()) {
                ++this.skipped;
                SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append("  " + Localization.lang("Skipped - No PDF linked", new String[0]) + ".\n"));
            } else {
                for (Path file2 : files) {
                    if (Files.exists(file2, new LinkOption[0])) {
                        try {
                            XmpUtilWriter.writeXmp(file2, entry, this.database, Globals.prefs.getXMPPreferences());
                            SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append("  " + Localization.lang("OK", new String[0]) + ".\n"));
                            ++this.entriesChanged;
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater(() -> {
                                this.optDiag.getProgressArea().append("  " + Localization.lang("Error while writing", new String[0]) + " '" + file2.toString() + "':\n");
                                this.optDiag.getProgressArea().append("    " + e.getLocalizedMessage() + "\n");
                            });
                            ++this.errors;
                        }
                        continue;
                    }
                    ++this.skipped;
                    SwingUtilities.invokeLater(() -> {
                        this.optDiag.getProgressArea().append("  " + Localization.lang("Skipped - PDF does not exist", new String[0]) + ":\n");
                        this.optDiag.getProgressArea().append("    " + file2.toString() + "\n");
                    });
                }
            }
            if (!this.optDiag.isCanceled()) continue;
            SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append("\n" + Localization.lang("Operation canceled.", new String[0]) + "\n"));
            break;
        }
        SwingUtilities.invokeLater(() -> {
            this.optDiag.getProgressArea().append("\n" + Localization.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
            this.optDiag.done();
        });
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Localization.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
    }

    class OptionsDialog
    extends JabRefDialog {
        private final JButton okButton;
        private final JButton cancelButton;
        private boolean canceled;
        private final JTextArea progressArea;

        public OptionsDialog(JFrame parent) {
            super((Frame)parent, Localization.lang("Writing XMP-metadata for selected entries...", new String[0]), false, OptionsDialog.class);
            this.okButton = new JButton(Localization.lang("OK", new String[0]));
            this.cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
            this.okButton.setEnabled(false);
            this.okButton.addActionListener(e -> this.dispose());
            AbstractAction cancel = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.canceled = true;
                }
            };
            this.cancelButton.addActionListener(cancel);
            InputMap im = this.cancelButton.getInputMap(2);
            ActionMap am = this.cancelButton.getActionMap();
            im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            am.put("close", cancel);
            this.progressArea = new JTextArea(15, 60);
            JScrollPane scrollPane = new JScrollPane(this.progressArea, 22, 31);
            Dimension d = this.progressArea.getPreferredSize();
            d.height += scrollPane.getHorizontalScrollBar().getHeight() + 15;
            d.width += scrollPane.getVerticalScrollBar().getWidth() + 15;
            WriteXMPAction.this.panel.setSize(d);
            this.progressArea.setBackground(Color.WHITE);
            this.progressArea.setEditable(false);
            this.progressArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.progressArea.setText("");
            JPanel tmpPanel = new JPanel();
            tmpPanel.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            tmpPanel.add(scrollPane);
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)this.okButton);
            bb.addRelatedGap();
            bb.addButton((JComponent)this.cancelButton);
            bb.addGlue();
            JPanel bbPanel = bb.getPanel();
            bbPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            this.getContentPane().add((Component)tmpPanel, "Center");
            this.getContentPane().add((Component)bbPanel, "South");
            this.pack();
            this.setResizable(false);
        }

        public void done() {
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
        }

        public void open() {
            this.progressArea.setText("");
            this.canceled = false;
            WriteXMPAction.this.optDiag.setLocationRelativeTo(WriteXMPAction.this.panel.frame());
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            this.okButton.requestFocus();
            WriteXMPAction.this.optDiag.setVisible(true);
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public JTextArea getProgressArea() {
            return this.progressArea;
        }
    }
}

