/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.Optional;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.JournalEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.gui.util.ControlHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.JabRefPreferences;

public class JournalEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private JournalEditorViewModel viewModel;
    @FXML
    private EditorTextArea textArea;
    private Optional<BibEntry> entry;

    public JournalEditor(String fieldName, JournalAbbreviationLoader journalAbbreviationLoader, JabRefPreferences preferences, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        this.viewModel = new JournalEditorViewModel(fieldName, suggestionProvider, journalAbbreviationLoader, preferences.getJournalAbbreviationPreferences(), fieldCheckers);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.textArea.textProperty().bindBidirectional((Property)this.viewModel.textProperty());
        this.textArea.addToContextMenu(EditorMenus.getDefaultMenu(this.textArea));
        AutoCompletionTextInputBinding.autoComplete((TextInputControl)this.textArea, this.viewModel::complete);
        new EditorValidator(preferences).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), this.textArea);
    }

    public JournalEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.entry = Optional.of(entry);
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void toggleAbbreviation(ActionEvent event) {
        this.viewModel.toggleAbbreviation();
    }
}

