/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.Optional;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.strings.StringUtil;

public class JournalEditorViewModel
extends AbstractEditorViewModel {
    private final JournalAbbreviationLoader journalAbbreviationLoader;
    private final JournalAbbreviationPreferences journalAbbreviationPreferences;

    public JournalEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, JournalAbbreviationLoader journalAbbreviationLoader, JournalAbbreviationPreferences journalAbbreviationPreferences, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.journalAbbreviationLoader = journalAbbreviationLoader;
        this.journalAbbreviationPreferences = journalAbbreviationPreferences;
    }

    public void toggleAbbreviation() {
        Optional<String> nextAbbreviation;
        if (StringUtil.isBlank((String)this.text.get())) {
            return;
        }
        JournalAbbreviationRepository abbreviationRepository = this.journalAbbreviationLoader.getRepository(this.journalAbbreviationPreferences);
        if (abbreviationRepository.isKnownName((String)this.text.get()) && (nextAbbreviation = abbreviationRepository.getNextAbbreviation((String)this.text.get())).isPresent()) {
            this.text.set((Object)nextAbbreviation.get());
        }
    }
}

