/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.filelist;

import java.util.Optional;
import org.jabref.gui.BasePanel;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.filelist.FileListEntryEditor;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;

public class AttachFileAction
implements BaseAction {
    private final BasePanel panel;

    public AttachFileAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void action() {
        Optional<FieldChange> fieldChange;
        if (this.panel.getSelectedEntries().size() != 1) {
            this.panel.output(Localization.lang("This operation requires exactly one item to be selected.", new String[0]));
            return;
        }
        BibEntry entry = this.panel.getSelectedEntries().get(0);
        LinkedFile flEntry = new LinkedFile("", "", "");
        FileListEntryEditor editor = new FileListEntryEditor(flEntry, false, true, this.panel.getBibDatabaseContext());
        editor.setVisible(true, true);
        if (editor.okPressed() && (fieldChange = entry.addFile(flEntry)).isPresent()) {
            UndoableFieldChange ce = new UndoableFieldChange(entry, "file", entry.getField("file").orElse(null), fieldChange.get().getNewValue());
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
        }
    }
}

