/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.help;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.jabref.Globals;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.Version;
import org.jabref.preferences.VersionPreferences;

public class NewVersionDialog
extends JabRefDialog {
    public NewVersionDialog(JFrame frame, Version currentVersion, final Version latestVersion) {
        super((Frame)frame, NewVersionDialog.class);
        this.setTitle(Localization.lang("New version available", new String[0]));
        JLabel lblTitle = new JLabel(Localization.lang("A new version of JabRef has been released.", new String[0]));
        JLabel lblCurrentVersion = new JLabel(Localization.lang("Installed version", new String[0]) + ": " + currentVersion.getFullVersion());
        JLabel lblLatestVersion = new JLabel(Localization.lang("Latest version", new String[0]) + ": " + latestVersion.getFullVersion());
        String localization = Localization.lang("To see what is new view the changelog.", new String[0]);
        JLabel lblMoreInformation = new JLabel("<HTML><a href=" + latestVersion.getChangelogUrl() + "'>" + localization + "</a></HTML>");
        lblMoreInformation.setCursor(Cursor.getPredefinedCursor(12));
        lblMoreInformation.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JabRefDesktop.openBrowserShowPopup(latestVersion.getChangelogUrl());
            }
        });
        JButton btnIgnoreUpdate = new JButton(Localization.lang("Ignore this update", new String[0]));
        btnIgnoreUpdate.addActionListener(e -> {
            Globals.prefs.storeVersionPreferences(new VersionPreferences(latestVersion));
            this.dispose();
        });
        JButton btnDownloadUpdate = new JButton(Localization.lang("Download update", new String[0]));
        btnDownloadUpdate.addActionListener(e -> {
            JabRefDesktop.openBrowserShowPopup("https://downloads.jabref.org");
            this.dispose();
        });
        JButton btnRemindMeLater = new JButton(Localization.lang("Remind me later", new String[0]));
        btnRemindMeLater.addActionListener(e -> this.dispose());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.fill = 1;
        c.insets = new Insets(2, 5, 5, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 3;
        panel.add((Component)lblTitle, c);
        c.gridy = 1;
        panel.add((Component)lblCurrentVersion, c);
        c.gridy = 2;
        panel.add((Component)lblLatestVersion, c);
        c.gridy = 3;
        panel.add((Component)lblMoreInformation, c);
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 1;
        panel.add((Component)btnDownloadUpdate, c);
        c.gridx = 1;
        panel.add((Component)btnIgnoreUpdate, c);
        c.gridx = 2;
        panel.add((Component)btnRemindMeLater, c);
        this.add(panel);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
    }
}

