/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.importer.fetcher.EntryFetcher;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.ImportInspector;
import org.jabref.logic.importer.OutputPrinter;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.importer.util.INSPIREBibtexFilterReader;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INSPIREFetcher
implements EntryFetcher {
    private static final String INSPIRE_HOST = "inspirehep.net";
    private static final Logger LOGGER = LoggerFactory.getLogger(INSPIREFetcher.class);

    private String constructUrl(String key) {
        String identifier;
        try {
            identifier = URLEncoder.encode(key, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        StringBuilder sb = new StringBuilder(87).append("https://").append(INSPIRE_HOST).append("/search?ln=en&ln=en&p=find+").append(identifier).append("&action_search=Search&sf=&so=d&rm=&rg=1000&sc=0&of=hx");
        LOGGER.debug("Inspire URL: " + sb + "\n");
        return sb.toString();
    }

    private BibDatabase importInspireEntries(String key) throws IOException {
        String url = this.constructUrl(key);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", "JabRef");
        InputStream inputStream = conn.getInputStream();
        try (INSPIREBibtexFilterReader reader = new INSPIREBibtexFilterReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            ParserResult pr = new BibtexParser(Globals.prefs.getImportFormatPreferences(), Globals.getFileUpdateMonitor()).parse(reader);
            BibDatabase bibDatabase = pr.getDatabase();
            return bibDatabase;
        }
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_INSPIRE;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "INSPIRE";
    }

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        try {
            status.setStatus(Localization.lang("Fetching entries from Inspire", new String[0]));
            BibDatabase bd = this.importInspireEntries(query);
            status.setStatus(Localization.lang("Adding fetched entries", new String[0]));
            bd.getEntries().forEach(dialog::addEntry);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)dialog).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }
}

