/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jabref.gui.SaveOrderConfigDisplay;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.JabRefPreferences;

class ExportSortingPrefsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private final JRadioButton exportInOriginalOrder;
    private final JRadioButton exportInTableOrder;
    private final JRadioButton exportInSpecifiedOrder;
    private final SaveOrderConfigDisplay exportOrderPanel;

    public ExportSortingPrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        FormLayout layout = new FormLayout("4dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.leadingColumnOffset(1);
        this.exportInOriginalOrder = new JRadioButton(Localization.lang("Export entries in their original order", new String[0]));
        this.exportInTableOrder = new JRadioButton(Localization.lang("Export in current table sort order", new String[0]));
        this.exportInSpecifiedOrder = new JRadioButton(Localization.lang("Export entries ordered as specified", new String[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.exportInOriginalOrder);
        buttonGroup.add(this.exportInTableOrder);
        buttonGroup.add(this.exportInSpecifiedOrder);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = e.getSource() == ExportSortingPrefsTab.this.exportInSpecifiedOrder;
                ExportSortingPrefsTab.this.exportOrderPanel.setEnabled(selected);
            }
        };
        this.exportInOriginalOrder.addActionListener(listener);
        this.exportInTableOrder.addActionListener(listener);
        this.exportInSpecifiedOrder.addActionListener(listener);
        builder.appendSeparator(Localization.lang("Export sort order", new String[0]));
        builder.append((Component)this.exportInOriginalOrder, 1);
        builder.nextLine();
        builder.append((Component)this.exportInTableOrder, 1);
        builder.nextLine();
        builder.append((Component)this.exportInSpecifiedOrder, 1);
        builder.nextLine();
        this.exportOrderPanel = new SaveOrderConfigDisplay();
        builder.append(this.exportOrderPanel.getPanel());
        builder.nextLine();
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        if (this.prefs.getBoolean("exportInOriginalOrder")) {
            this.exportInOriginalOrder.setSelected(true);
        } else if (this.prefs.getBoolean("exportInSpecifiedOrder")) {
            this.exportInSpecifiedOrder.setSelected(true);
        } else {
            this.exportInTableOrder.setSelected(true);
        }
        boolean selected = this.prefs.getBoolean("exportInSpecifiedOrder");
        this.exportOrderPanel.setEnabled(selected);
        this.exportOrderPanel.setSaveOrderConfig(this.prefs.loadExportSaveOrder());
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("exportInOriginalOrder", this.exportInOriginalOrder.isSelected());
        this.prefs.putBoolean("exportInSpecifiedOrder", this.exportInSpecifiedOrder.isSelected());
        this.prefs.storeExportSaveOrder(this.exportOrderPanel.getSaveOrderConfig());
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Export sorting", new String[0]);
    }
}

