/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.JabRefPreferences;

class GroupsPrefsTab
extends JPanel
implements PrefsTab {
    private final JCheckBox hideNonHits = new JCheckBox(Localization.lang("Hide non-hits", new String[0]));
    private final JCheckBox grayOut = new JCheckBox(Localization.lang("Gray out non-hits", new String[0]));
    private final JCheckBox autoAssignGroup = new JCheckBox(Localization.lang("Automatically assign new entry to selected groups", new String[0]));
    private final JRadioButton multiSelectionModeIntersection = new JRadioButton(Localization.lang("Intersection", new String[0]));
    private final JRadioButton multiSelectionModeUnion = new JRadioButton(Localization.lang("Union", new String[0]));
    private final JTextField groupingField = new JTextField(20);
    private final JTextField keywordSeparator = new JTextField(2);
    private final JabRefPreferences prefs;

    public GroupsPrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.keywordSeparator.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GroupsPrefsTab.this.keywordSeparator.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        ButtonGroup hideMode = new ButtonGroup();
        hideMode.add(this.grayOut);
        hideMode.add(this.hideNonHits);
        ButtonGroup multiSelectionMode = new ButtonGroup();
        multiSelectionMode.add(this.multiSelectionModeIntersection);
        multiSelectionMode.add(this.multiSelectionModeUnion);
        this.multiSelectionModeIntersection.setToolTipText(Localization.lang("Display only entries belonging to all selected groups.", new String[0]));
        this.multiSelectionModeUnion.setToolTipText(Localization.lang("Display all entries belonging to one or more of the selected groups.", new String[0]));
        FormLayout layout = new FormLayout("9dlu, pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Localization.lang("View", new String[0]));
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.hideNonHits);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.grayOut);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.multiSelectionModeIntersection);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.multiSelectionModeUnion);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.autoAssignGroup);
        builder.nextLine();
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Dynamic groups", new String[0]));
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        FormLayout layout2 = new FormLayout("left:pref, 2dlu, left:pref", "p, 3dlu, p");
        DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
        builder2.append(new JLabel(Localization.lang("Default grouping field", new String[0]) + ":"));
        builder2.append(this.groupingField);
        builder2.nextLine();
        builder2.nextLine();
        builder2.append(new JLabel(Localization.lang("When adding/removing keywords, separate them by", new String[0]) + ":"));
        builder2.append(this.keywordSeparator);
        builder.append(builder2.getPanel());
        this.setLayout(new BorderLayout());
        JPanel panel = builder.getPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)panel, "Center");
    }

    @Override
    public void setValues() {
        this.grayOut.setSelected(this.prefs.getBoolean("grayOutNonHits"));
        this.groupingField.setText(this.prefs.get("groupsDefaultField"));
        this.keywordSeparator.setText(this.prefs.get("groupKeywordSeparator"));
        this.autoAssignGroup.setSelected(this.prefs.getBoolean("autoAssignGroup"));
        this.multiSelectionModeIntersection.setSelected(this.prefs.getBoolean("groupIntersectSelections"));
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("grayOutNonHits", this.grayOut.isSelected());
        this.prefs.put("groupsDefaultField", this.groupingField.getText().trim());
        this.prefs.putBoolean("autoAssignGroup", this.autoAssignGroup.isSelected());
        this.prefs.put("groupKeywordSeparator", this.keywordSeparator.getText());
        this.prefs.putBoolean("groupIntersectSelections", this.multiSelectionModeIntersection.isSelected());
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Groups", new String[0]);
    }
}

