/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.push.PushToApplication;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

class PushToApplicationAction
extends AbstractAction
implements Runnable {
    private final PushToApplication operation;
    private final JabRefFrame frame;
    private BasePanel panel;
    private List<BibEntry> entries;

    public PushToApplicationAction(JabRefFrame frame, PushToApplication operation) {
        this.frame = frame;
        this.putValue("SmallIcon", operation.getIcon());
        this.putValue("Name", operation.getName());
        this.putValue("ShortDescription", operation.getTooltip());
        this.operation = operation;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.panel = this.frame.getCurrentBasePanel();
        if (this.panel == null) {
            return;
        }
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.isEmpty()) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("This operation requires one or more entries to be selected.", new String[0]), (String)this.getValue("Name"), 0);
            return;
        }
        if (this.operation.requiresBibtexKeys()) {
            for (BibEntry entry : this.entries) {
                if (entry.getCiteKeyOptional().isPresent() && !entry.getCiteKeyOptional().get().trim().isEmpty()) continue;
                JOptionPane.showMessageDialog(this.frame, Localization.lang("This operation requires all selected entries to have BibTeX keys defined.", new String[0]), (String)this.getValue("Name"), 0);
                return;
            }
        }
        JabRefExecutorService.INSTANCE.execute(this);
    }

    @Override
    public void run() {
        this.operation.pushEntries(this.panel.getDatabase(), this.entries, PushToApplicationAction.getKeyString(this.entries), this.panel.getBibDatabaseContext().getMetaData());
        SwingUtilities.invokeLater(() -> this.operation.operationCompleted(this.panel));
    }

    private static String getKeyString(List<BibEntry> bibentries) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (BibEntry bes : bibentries) {
            Optional<String> citeKey = bes.getCiteKeyOptional();
            if (!citeKey.isPresent() || citeKey.get().isEmpty()) continue;
            if (first) {
                result.append(citeKey.get());
                first = false;
                continue;
            }
            result.append(',').append(citeKey.get());
        }
        return result.toString();
    }
}

