/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jabref.Globals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplicationAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;

public class PushToApplicationButton
implements ActionListener {
    private static final Icon ARROW_ICON = IconTheme.JabRefIcon.DOWN.getSmallIcon();
    private final JabRefFrame frame;
    private final List<PushToApplication> pushActions;
    private JPanel comp;
    private JButton pushButton;
    private PushToApplication toApp;
    private JPopupMenu popup;
    private final Map<PushToApplication, PushToApplicationAction> actions = new HashMap<PushToApplication, PushToApplicationAction>();
    private final Dimension buttonDim = new Dimension(23, 23);
    private final MenuAction mAction = new MenuAction();
    private final JPopupMenu optPopup = new JPopupMenu();
    private final JMenuItem settings = new JMenuItem(Localization.lang("Settings", new String[0]));

    public PushToApplicationButton(JabRefFrame frame, List<PushToApplication> pushActions) {
        this.frame = frame;
        this.pushActions = pushActions;
        this.init();
    }

    private void init() {
        this.comp = new JPanel();
        this.comp.setLayout(new BorderLayout());
        JButton menuButton = new JButton(ARROW_ICON);
        menuButton.setMargin(new Insets(0, 0, 0, 0));
        menuButton.setPreferredSize(new Dimension(menuButton.getIcon().getIconWidth(), menuButton.getIcon().getIconHeight()));
        menuButton.addActionListener(e -> {
            if (this.popup == null) {
                this.buildPopupMenu();
            }
            this.popup.show(this.comp, 0, menuButton.getHeight());
        });
        menuButton.setToolTipText(Localization.lang("Select external application", new String[0]));
        this.pushButton = new JButton();
        if (OS.OS_X) {
            menuButton.putClientProperty("JButton.buttonType", "toolbar");
            this.pushButton.putClientProperty("JButton.buttonType", "toolbar");
        }
        String appSelected = Globals.prefs.get("pushToApplication");
        for (PushToApplication application : this.pushActions) {
            if (!application.getApplicationName().equals(appSelected)) continue;
            this.toApp = application;
            break;
        }
        if (this.toApp == null) {
            this.toApp = this.pushActions.get(0);
        }
        this.setSelected();
        this.pushButton.addActionListener(this);
        this.pushButton.addMouseListener(new PushButtonMouseListener());
        this.pushButton.setOpaque(false);
        menuButton.setOpaque(false);
        this.comp.setOpaque(false);
        this.comp.add((Component)this.pushButton, "Center");
        this.comp.add((Component)menuButton, "East");
        this.comp.setMaximumSize(this.comp.getPreferredSize());
        this.optPopup.add(this.settings);
        this.settings.addActionListener(event -> {
            JPanel options = this.toApp.getSettingsPanel();
            if (options != null) {
                PushToApplicationButton.showSettingsDialog(this.frame, this.toApp, options);
            }
        });
        this.buildPopupMenu();
    }

    private void buildPopupMenu() {
        this.popup = new JPopupMenu();
        for (PushToApplication application : this.pushActions) {
            JMenuItem item = new JMenuItem(application.getApplicationName(), application.getIcon());
            item.setToolTipText(application.getTooltip());
            item.addActionListener(new PopupItemActionListener(application));
            this.popup.add(item);
        }
    }

    private void setSelected(PushToApplication newApplication) {
        this.toApp = newApplication;
        this.setSelected();
    }

    private void setSelected() {
        this.pushButton.setIcon(this.toApp.getIcon());
        this.pushButton.setToolTipText(this.toApp.getTooltip());
        this.pushButton.setPreferredSize(this.buttonDim);
        Globals.prefs.put("pushToApplication", this.toApp.getApplicationName());
        this.mAction.setTitle(this.toApp.getApplicationName());
        this.mAction.setIcon(this.toApp.getIcon());
    }

    public Component getComponent() {
        return this.comp;
    }

    public Action getMenuAction() {
        return this.mAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PushToApplicationAction action = this.actions.get(this.toApp);
        if (action == null) {
            action = new PushToApplicationAction(this.frame, this.toApp);
            this.actions.put(this.toApp, action);
        }
        action.actionPerformed(new ActionEvent(this.toApp, 0, "push"));
    }

    public static void showSettingsDialog(JFrame parent, PushToApplication toApp, JPanel options) {
        BooleanHolder okPressed = new BooleanHolder(false);
        final JDialog diag = new JDialog(parent, Localization.lang("Settings", new String[0]), true);
        options.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        diag.getContentPane().add((Component)options, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        diag.getContentPane().add((Component)bb.getPanel(), "South");
        ok.addActionListener(e -> {
            okPressed.value = true;
            diag.dispose();
        });
        cancel.addActionListener(e -> diag.dispose());
        ActionMap am = bb.getPanel().getActionMap();
        InputMap im = bb.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        diag.pack();
        diag.setLocationRelativeTo(parent);
        diag.setVisible(true);
        if (okPressed.value) {
            toApp.storeSettings();
        }
    }

    class PushButtonMouseListener
    extends MouseAdapter {
        PushButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.processPopupTrigger(event);
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.processPopupTrigger(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.processPopupTrigger(event);
            }
        }

        private void processPopupTrigger(MouseEvent e) {
            if (PushToApplicationButton.this.toApp.getSettingsPanel() != null) {
                PushToApplicationButton.this.optPopup.show(PushToApplicationButton.this.pushButton, e.getX(), e.getY());
            }
        }
    }

    class MenuAction
    extends MnemonicAwareAction {
        public MenuAction() {
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.PUSH_TO_APPLICATION));
        }

        public void setTitle(String appName) {
            this.putValue("Name", Localization.menuTitle("Push entries to external application (%0)", appName));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PushToApplicationButton.this.actionPerformed(null);
        }

        public void setIcon(Icon icon) {
            this.putValue("SmallIcon", icon);
        }
    }

    class PopupItemActionListener
    implements ActionListener {
        private final PushToApplication application;

        public PopupItemActionListener(PushToApplication application) {
            this.application = application;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PushToApplicationButton.this.setSelected(this.application);
            PushToApplicationButton.this.pushButton.requestFocus();
        }
    }

    private static class BooleanHolder {
        public boolean value;

        public BooleanHolder(boolean value) {
            this.value = value;
        }
    }
}

