/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.css.PseudoClass;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.text.TextFlow;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.gui.AbstractView;
import org.jabref.gui.BasePanel;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.OSXCompatibleToolbar;
import org.jabref.gui.autocompleter.AppendPersonNamesStrategy;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.autocompleter.PersonNameStringConverter;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.gui.search.GlobalSearchWorker;
import org.jabref.gui.search.SearchDisplayMode;
import org.jabref.gui.search.SearchResultFrame;
import org.jabref.gui.search.SearchTextField;
import org.jabref.gui.search.SearchWorker;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.logic.search.SearchQueryHighlightObservable;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.SearchPreferences;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSearchBar
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSearchBar.class);
    private static final int SEARCH_DELAY = 400;
    private static final PseudoClass CLASS_NO_RESULTS = PseudoClass.getPseudoClass((String)"emptyResult");
    private static final PseudoClass CLASS_RESULTS_FOUND = PseudoClass.getPseudoClass((String)"emptyResult");
    private final JabRefFrame frame;
    private final TextField searchField = SearchTextField.create();
    private final JToggleButton caseSensitive;
    private final JToggleButton regularExp;
    private final JButton searchModeButton = new JButton();
    private final JLabel currentResults = new JLabel("");
    private final SearchQueryHighlightObservable searchQueryHighlightObservable = new SearchQueryHighlightObservable();
    private final JButton openCurrentResultsInDialog = new JButton(IconTheme.JabRefIcon.OPEN_IN_NEW_WINDOW.getSmallIcon());
    private final JFXPanel container;
    private SearchWorker searchWorker;
    private GlobalSearchWorker globalSearchWorker;
    private SearchResultFrame searchResultFrame;
    private SearchDisplayMode searchDisplayMode;
    private final JLabel searchIcon = new JLabel(IconTheme.JabRefIcon.SEARCH.getIcon());
    private boolean dontSelectSearchBar;

    public GlobalSearchBar(JabRefFrame frame) {
        this.frame = Objects.requireNonNull(frame);
        final SearchPreferences searchPreferences = new SearchPreferences(Globals.prefs);
        this.searchDisplayMode = searchPreferences.getSearchMode();
        this.currentResults.setPreferredSize(new Dimension(150, 5));
        this.currentResults.setFont(this.currentResults.getFont().deriveFont(1));
        final JToggleButton globalSearch = new JToggleButton(IconTheme.JabRefIcon.GLOBAL_SEARCH.getSmallIcon(), searchPreferences.isGlobalSearch());
        globalSearch.setToolTipText(Localization.lang("Search in all open libraries", new String[0]));
        final AbstractAction globalSearchStandardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchPreferences.setGlobalSearch(globalSearch.isSelected());
                GlobalSearchBar.this.updateOpenCurrentResultsTooltip(globalSearch.isSelected());
            }
        };
        AbstractAction globalSearchShortCutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                globalSearch.setSelected(true);
                globalSearchStandardAction.actionPerformed(new ActionEvent(this, 0, "fire standard action"));
                GlobalSearchBar.this.focus();
            }
        };
        String searchGlobalByKey = "searchGlobalByKey";
        globalSearch.getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.GLOBAL_SEARCH), searchGlobalByKey);
        globalSearch.getActionMap().put(searchGlobalByKey, globalSearchShortCutAction);
        globalSearch.addActionListener(globalSearchStandardAction);
        this.openCurrentResultsInDialog.setDisabledIcon(IconTheme.JabRefIcon.OPEN_IN_NEW_WINDOW.getSmallIcon().createDisabledIcon());
        this.openCurrentResultsInDialog.addActionListener(event -> {
            if (globalSearch.isSelected()) {
                this.performGlobalSearch();
            } else {
                this.openLocalFindingsInExternalPanel();
            }
        });
        this.openCurrentResultsInDialog.setEnabled(false);
        this.updateOpenCurrentResultsTooltip(globalSearch.isSelected());
        this.regularExp = new JToggleButton(IconTheme.JabRefIcon.REG_EX.getSmallIcon(), searchPreferences.isRegularExpression());
        this.regularExp.setToolTipText(Localization.lang("regular expression", new String[0]));
        this.regularExp.addActionListener(event -> {
            searchPreferences.setRegularExpression(this.regularExp.isSelected());
            this.performSearch();
        });
        this.caseSensitive = new JToggleButton(IconTheme.JabRefIcon.CASE_SENSITIVE.getSmallIcon(), searchPreferences.isCaseSensitive());
        this.caseSensitive.setToolTipText(Localization.lang("Case sensitive", new String[0]));
        this.caseSensitive.addActionListener(event -> {
            searchPreferences.setCaseSensitive(this.caseSensitive.isSelected());
            this.performSearch();
        });
        this.updateSearchModeButtonText();
        this.searchModeButton.addActionListener(event -> this.toggleSearchModeAndSearch());
        Timer searchTask = FxTimer.create(Duration.ofMillis(400L), () -> {
            LOGGER.debug("Run search " + this.searchField.getText());
            this.performSearch();
        });
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> searchTask.restart());
        this.container = CustomJFXPanel.create();
        DefaultTaskExecutor.runInJavaFXThread(() -> {
            Scene scene = new Scene((Parent)this.searchField);
            scene.getStylesheets().add((Object)AbstractView.class.getResource("Main.css").toExternalForm());
            this.container.setScene(scene);
            this.container.addKeyListener((KeyListener)new SearchKeyAdapter());
        });
        this.setLayout(new FlowLayout(2));
        OSXCompatibleToolbar toolBar = new OSXCompatibleToolbar();
        toolBar.setFloatable(false);
        ((Container)toolBar).add(this.searchIcon);
        ((Container)toolBar).add((Component)this.container);
        ((Container)toolBar).add(this.openCurrentResultsInDialog);
        toolBar.addSeparator();
        ((Container)toolBar).add(globalSearch);
        ((Container)toolBar).add(this.regularExp);
        ((Container)toolBar).add(this.caseSensitive);
        ((Container)toolBar).add(this.searchModeButton);
        toolBar.addSeparator();
        toolBar.add(new HelpAction(HelpFile.SEARCH));
        toolBar.addSeparator();
        ((Container)toolBar).add(this.currentResults);
        this.add(toolBar);
    }

    public void performGlobalSearch() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel == null || this.validateSearchResultFrame(true)) {
            return;
        }
        if (this.globalSearchWorker != null) {
            this.globalSearchWorker.cancel(true);
        }
        if (this.searchField.getText().isEmpty()) {
            this.focus();
            return;
        }
        this.globalSearchWorker = new GlobalSearchWorker(currentBasePanel.frame(), this.getSearchQuery());
        this.globalSearchWorker.execute();
    }

    private void openLocalFindingsInExternalPanel() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel == null || this.validateSearchResultFrame(false)) {
            return;
        }
        if (this.searchField.getText().isEmpty()) {
            this.focus();
            return;
        }
        SearchResultFrame searchDialog = new SearchResultFrame(currentBasePanel.frame(), Localization.lang("Search results in library %0 for %1", currentBasePanel.getBibDatabaseContext().getDatabasePath().map(Path::getFileName).map(Path::toString).orElse(GUIGlobals.UNTITLED_TITLE), this.getSearchQuery().localize()), this.getSearchQuery(), false);
        List<BibEntry> entries = currentBasePanel.getDatabase().getEntries().stream().filter(BibEntry::isSearchHit).collect(Collectors.toList());
        searchDialog.addEntries(entries, currentBasePanel);
        searchDialog.selectFirstEntry();
        searchDialog.setVisible(true);
    }

    private boolean validateSearchResultFrame(boolean globalSearch) {
        if (this.searchResultFrame != null) {
            if (this.searchResultFrame.isGlobalSearch() == globalSearch && this.isStillValidQuery(this.searchResultFrame.getSearchQuery())) {
                this.searchResultFrame.focus();
                return true;
            }
            this.searchResultFrame.dispose();
            return false;
        }
        return false;
    }

    private void toggleSearchModeAndSearch() {
        int nextSearchMode = (this.searchDisplayMode.ordinal() + 1) % SearchDisplayMode.values().length;
        this.searchDisplayMode = SearchDisplayMode.values()[nextSearchMode];
        new SearchPreferences(Globals.prefs).setSearchMode(this.searchDisplayMode);
        this.updateSearchModeButtonText();
        this.performSearch();
    }

    private void updateSearchModeButtonText() {
        this.searchModeButton.setText(this.searchDisplayMode.getDisplayName());
        this.searchModeButton.setToolTipText(this.searchDisplayMode.getToolTipText());
    }

    public void endSearch() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel != null) {
            this.clearSearch(currentBasePanel);
            MainTable mainTable = this.frame.getCurrentBasePanel().getMainTable();
            Globals.getFocusListener().setFocused(mainTable);
            mainTable.requestFocus();
            SwingUtilities.invokeLater(() -> mainTable.ensureVisible(mainTable.getSelectedRow()));
        }
    }

    public void focus() {
        if (!this.searchField.isFocused()) {
            this.container.requestFocus();
            this.searchField.requestFocus();
        }
        this.searchField.selectAll();
    }

    private void clearSearch(BasePanel currentBasePanel) {
        this.currentResults.setText("");
        this.searchField.setText("");
        this.searchQueryHighlightObservable.reset();
        this.openCurrentResultsInDialog.setEnabled(false);
        if (currentBasePanel != null) {
            currentBasePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.DISABLED);
            currentBasePanel.setCurrentSearchQuery(null);
        }
        if (this.dontSelectSearchBar) {
            this.dontSelectSearchBar = false;
            return;
        }
        this.focus();
    }

    public void performSearch() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel == null) {
            return;
        }
        if (this.searchWorker != null) {
            this.searchWorker.cancel(true);
        }
        if (this.searchField.getText().isEmpty()) {
            this.clearSearch(currentBasePanel);
            this.searchIcon.setIcon(IconTheme.JabRefIcon.SEARCH.getIcon());
            return;
        }
        SearchQuery searchQuery = this.getSearchQuery();
        if (!searchQuery.isValid()) {
            this.informUserAboutInvalidSearchQuery();
            return;
        }
        this.searchWorker = new SearchWorker(currentBasePanel, searchQuery, this.searchDisplayMode);
        this.searchWorker.execute();
    }

    private void informUserAboutInvalidSearchQuery() {
        this.searchField.pseudoClassStateChanged(CLASS_NO_RESULTS, true);
        this.searchQueryHighlightObservable.reset();
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        currentBasePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.DISABLED);
        String illegalSearch = Localization.lang("Search failed: illegal search expression", new String[0]);
        this.currentResults.setText(illegalSearch);
        this.openCurrentResultsInDialog.setEnabled(false);
    }

    public void setAutoCompleter(AutoCompleteSuggestionProvider<Author> searchCompleter) {
        if (Globals.prefs.getAutoCompletePreferences().shouldAutoComplete()) {
            AutoCompletionTextInputBinding.autoComplete((TextInputControl)this.searchField, searchCompleter, new PersonNameStringConverter(false, false, AutoCompleteFirstNameMode.BOTH), new AppendPersonNamesStrategy());
        }
    }

    public SearchQueryHighlightObservable getSearchQueryHighlightObservable() {
        return this.searchQueryHighlightObservable;
    }

    public boolean isStillValidQuery(SearchQuery query) {
        return query.getQuery().equals(this.searchField.getText()) && query.isRegularExpression() == this.regularExp.isSelected() && query.isCaseSensitive() == this.caseSensitive.isSelected();
    }

    private SearchQuery getSearchQuery() {
        SearchQuery searchQuery = new SearchQuery(this.searchField.getText(), this.caseSensitive.isSelected(), this.regularExp.isSelected());
        this.frame.getCurrentBasePanel().setCurrentSearchQuery(searchQuery);
        return searchQuery;
    }

    public void updateResults(int matched, TextFlow description, boolean grammarBasedSearch) {
        if (matched == 0) {
            this.currentResults.setText(Localization.lang("No results found.", new String[0]));
            this.searchField.pseudoClassStateChanged(CLASS_NO_RESULTS, true);
        } else {
            this.currentResults.setText(Localization.lang("Found %0 results.", String.valueOf(matched)));
            this.searchField.pseudoClassStateChanged(CLASS_RESULTS_FOUND, true);
        }
        if (grammarBasedSearch) {
            this.searchIcon.setIcon(IconTheme.JabRefIcon.ADVANCED_SEARCH.getIcon());
        } else {
            this.searchIcon.setIcon(IconTheme.JabRefIcon.SEARCH.getIcon());
        }
        Tooltip tooltip = new Tooltip();
        tooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        tooltip.setGraphic((Node)description);
        tooltip.setMaxHeight(10.0);
        DefaultTaskExecutor.runInJavaFXThread(() -> this.searchField.setTooltip(tooltip));
        this.openCurrentResultsInDialog.setEnabled(true);
    }

    public void setSearchResultFrame(SearchResultFrame searchResultFrame) {
        this.searchResultFrame = searchResultFrame;
    }

    public void setSearchTerm(String searchTerm) {
        if (searchTerm.equals(this.searchField.getText())) {
            return;
        }
        this.setDontSelectSearchBar();
        DefaultTaskExecutor.runInJavaFXThread(() -> this.searchField.setText(searchTerm));
    }

    public void setDontSelectSearchBar() {
        this.dontSelectSearchBar = true;
    }

    private void updateOpenCurrentResultsTooltip(boolean globalSearchEnabled) {
        if (globalSearchEnabled) {
            this.openCurrentResultsInDialog.setToolTipText(Localization.lang("Show global search results in a window", new String[0]));
        } else {
            this.openCurrentResultsInDialog.setToolTipText(Localization.lang("Show search results in a window", new String[0]));
        }
    }

    private class SearchKeyAdapter
    extends KeyAdapter {
        private SearchKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 27: {
                    this.clearOnEsc();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    e.consume();
                    break;
                }
            }
            Optional<KeyBinding> keyBinding = Globals.getKeyPrefs().mapToKeyBinding(e);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case CUT: 
                    case COPY: 
                    case PASTE: 
                    case DELETE_ENTRY: 
                    case SELECT_ALL: {
                        e.consume();
                        break;
                    }
                }
            }
        }

        private void clearOnEsc() {
            MainTable currentTable = GlobalSearchBar.this.frame.getCurrentBasePanel().getMainTable();
            GlobalSearchBar.this.clearSearch(GlobalSearchBar.this.frame.getCurrentBasePanel());
            currentTable.setSelected(0);
        }
    }
}

