/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentThreadTaskExecutor
implements TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentThreadTaskExecutor.class);

    @Override
    public <V> Future<?> execute(BackgroundTask<V> task) {
        Runnable onRunning = task.getOnRunning();
        if (onRunning != null) {
            onRunning.run();
        }
        try {
            V result = task.call();
            Consumer<V> onSuccess = task.getOnSuccess();
            if (onSuccess != null) {
                onSuccess.accept(result);
            }
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception exception) {
            Consumer<Exception> onException = task.getOnException();
            if (onException != null) {
                onException.accept(exception);
            } else {
                LOGGER.error("Unhandled exception", exception);
            }
            return new FailedFuture(exception);
        }
    }

    @Override
    public void shutdown() {
    }

    private class FailedFuture<T>
    implements Future<T> {
        private final Throwable exception;

        FailedFuture(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public T get() throws ExecutionException {
            throw new ExecutionException(this.exception);
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException {
            return this.get();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

