/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileUpdateMonitor
implements Runnable,
FileUpdateMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileUpdateMonitor.class);
    private final Multimap<Path, FileUpdateListener> listeners = ArrayListMultimap.create(20, 4);
    private WatchService watcher;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Throwable throwable = null;
            try {
                this.watcher = watcher;
                while (true) {
                    WatchKey key;
                    try {
                        key = watcher.take();
                    }
                    catch (InterruptedException e) {
                        if (watcher == null) return;
                        if (throwable == null) {
                            watcher.close();
                            return;
                        }
                        try {
                            watcher.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return;
                        }
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            Thread.yield();
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            WatchEvent<?> ev = event;
                            Path path = ((Path)key.watchable()).resolve((Path)ev.context());
                            this.notifyAboutChange(path);
                        }
                        key.reset();
                    }
                    Thread.yield();
                    continue;
                    break;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (watcher == null) throw throwable4;
                if (throwable == null) {
                    watcher.close();
                    throw throwable4;
                }
                try {
                    watcher.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.debug("FileUpdateMonitor has been interrupted. Terminating...", e);
            return;
        }
    }

    private void notifyAboutChange(Path path) {
        this.listeners.get(path).forEach(FileUpdateListener::fileUpdated);
    }

    @Override
    public void addListenerForFile(Path file, FileUpdateListener listener) throws IOException {
        Path directory = file.toAbsolutePath().getParent();
        directory.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        this.listeners.put(file, listener);
    }

    @Override
    public void removeListener(Path path, FileUpdateListener listener) {
        this.listeners.remove(path, listener);
    }
}

