/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.entry.Month;
import org.jabref.model.metadata.SaveOrderConfig;
import org.jabref.model.strings.StringUtil;

public class FieldComparator
implements Comparator<BibEntry> {
    private static final Collator COLLATOR = FieldComparator.getCollator();
    private final String[] field;
    private final String fieldName;
    private final FieldType fieldType;
    private final boolean isNumeric;
    private final int multiplier;

    public FieldComparator(String field2) {
        this(field2, false);
    }

    public FieldComparator(SaveOrderConfig.SortCriterion sortCriterion) {
        this(sortCriterion.field, sortCriterion.descending);
    }

    public FieldComparator(String field2, boolean descending) {
        this.fieldName = Objects.requireNonNull(field2);
        this.field = this.fieldName.split("/");
        this.fieldType = this.determineFieldType();
        this.isNumeric = InternalBibtexFields.isNumeric(this.field[0]);
        this.multiplier = descending ? -1 : 1;
    }

    private static Collator getCollator() {
        try {
            return new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules().replace("<'_'", "<' '<'_'"));
        }
        catch (ParseException e) {
            return Collator.getInstance();
        }
    }

    private FieldType determineFieldType() {
        if ("entrytype".equals(this.field[0])) {
            return FieldType.TYPE;
        }
        if (InternalBibtexFields.getFieldProperties(this.field[0]).contains((Object)FieldProperty.PERSON_NAMES)) {
            return FieldType.NAME;
        }
        if ("year".equals(this.field[0])) {
            return FieldType.YEAR;
        }
        if ("month".equals(this.field[0])) {
            return FieldType.MONTH;
        }
        return FieldType.OTHER;
    }

    private String getField(BibEntry entry) {
        for (String aField : this.field) {
            Optional<String> o = entry.getFieldOrAliasLatexFree(aField);
            if (!o.isPresent()) continue;
            return o.get();
        }
        return null;
    }

    @Override
    public int compare(BibEntry e1, BibEntry e2) {
        String f2;
        String f1;
        if (this.fieldType == FieldType.TYPE) {
            f1 = e1.getType();
            f2 = e2.getType();
        } else {
            f1 = this.getField(e1);
            f2 = this.getField(e2);
        }
        if (f1 == null && f2 == null) {
            return 0;
        }
        if (f1 == null) {
            return this.multiplier;
        }
        if (f2 == null) {
            return -this.multiplier;
        }
        if (this.fieldType == FieldType.NAME) {
            f1 = AuthorList.fixAuthorForAlphabetization(f1);
            f2 = AuthorList.fixAuthorForAlphabetization(f2);
        } else {
            if (this.fieldType == FieldType.YEAR) {
                Integer f1year = StringUtil.intValueOfOptional(f1).orElse(0);
                Integer f2year = StringUtil.intValueOfOptional(f2).orElse(0);
                int comparisonResult = Integer.compare(f1year, f2year);
                return comparisonResult * this.multiplier;
            }
            if (this.fieldType == FieldType.MONTH) {
                int month1 = Month.parse(f1).map(Month::getNumber).orElse(-1);
                int month2 = Month.parse(f2).map(Month::getNumber).orElse(-1);
                return Integer.compare(month1, month2) * this.multiplier;
            }
        }
        if (this.isNumeric) {
            Optional<Integer> i1 = StringUtil.intValueOfOptional(f1);
            Optional<Integer> i2 = StringUtil.intValueOfOptional(f2);
            if (i2.isPresent() && i1.isPresent()) {
                return i1.get().compareTo(i2.get()) * this.multiplier;
            }
            if (i1.isPresent()) {
                return -1 * this.multiplier;
            }
            if (i2.isPresent()) {
                return 1 * this.multiplier;
            }
        }
        String ours = f1.toLowerCase(Locale.ENGLISH);
        String theirs = f2.toLowerCase(Locale.ENGLISH);
        return COLLATOR.compare(ours, theirs) * this.multiplier;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    static enum FieldType {
        NAME,
        TYPE,
        YEAR,
        MONTH,
        OTHER;

    }
}

