/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.Optional;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.MetaData;

public class GroupDiff {
    private final GroupTreeNode originalGroupRoot;
    private final GroupTreeNode newGroupRoot;

    private GroupDiff(GroupTreeNode originalGroupRoot, GroupTreeNode newGroupRoot) {
        this.originalGroupRoot = originalGroupRoot;
        this.newGroupRoot = newGroupRoot;
    }

    public static Optional<GroupDiff> compare(MetaData originalMetaData, MetaData newMetaData) {
        Optional<GroupTreeNode> newGroups;
        Optional<GroupTreeNode> originalGroups = originalMetaData.getGroups();
        if (!originalGroups.equals(newGroups = newMetaData.getGroups())) {
            return Optional.of(new GroupDiff(newGroups.orElse(null), originalGroups.orElse(null)));
        }
        return Optional.empty();
    }

    public GroupTreeNode getOriginalGroupRoot() {
        return this.originalGroupRoot;
    }

    public GroupTreeNode getNewGroupRoot() {
        return this.newGroupRoot;
    }
}

