/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.regex.Pattern;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

public class LatexCleanupFormatter
extends Formatter {
    private static final Pattern REMOVE_REDUNDANT = Pattern.compile("(?<!\\\\[\\p{Alpha}]{0,100}\\{[^\\}]{0,100})\\}([-/ ]?)\\{");
    private static final Pattern REPLACE_WITH_AT = Pattern.compile("(^|[^\\\\$])\\$");
    private static final Pattern REPLACE_EVERY_OTHER_AT = Pattern.compile("([^@]*)@@([^@]*)@@");
    private static final Pattern MOVE_NUMBERS_WITH_OPERATORS = Pattern.compile("([0-9\\(\\.]+[ ]?[-+/]?[ ]?)\\$");
    private static final Pattern MOVE_NUMBERS_RIGHT_INTO_EQUATION = Pattern.compile("@@([ ]?[-+/]?[ ]?[0-9\\)\\.]+)");
    private static final Pattern ESCAPE_PERCENT_SIGN_ONCE = Pattern.compile("(^|[^\\\\%])%");

    @Override
    public String getName() {
        return Localization.lang("LaTeX cleanup", new String[0]);
    }

    @Override
    public String getKey() {
        return "latex_cleanup";
    }

    @Override
    public String format(String oldString) {
        String newValue = oldString;
        newValue = newValue.replace("$$", "");
        newValue = REMOVE_REDUNDANT.matcher(newValue).replaceAll("$1");
        newValue = REPLACE_WITH_AT.matcher(newValue).replaceAll("$1@@");
        newValue = REPLACE_EVERY_OTHER_AT.matcher(newValue).replaceAll("$1\\$$2@@");
        newValue = MOVE_NUMBERS_WITH_OPERATORS.matcher(newValue).replaceAll("\\$$1");
        newValue = MOVE_NUMBERS_RIGHT_INTO_EQUATION.matcher(newValue).replaceAll(" $1@@");
        newValue = newValue.replace("@@", "$");
        newValue = newValue.replace("  ", " ");
        newValue = newValue.replace("$$", "");
        newValue = newValue.replace(" )$", ")$");
        newValue = ESCAPE_PERCENT_SIGN_ONCE.matcher(newValue).replaceAll("$1\\\\%");
        return newValue;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Cleans up LaTeX code.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "{VLSI} {DSP}";
    }
}

