/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

public class NormalizePagesFormatter
extends Formatter {
    private static final Pattern PAGES_DETECT_PATTERN = Pattern.compile("\\A(?<startpage>(\\d+:)?\\d+)(?:-{1,2}(?<endpage>(\\d+:)?\\d+))?\\Z");
    private static final String REJECT_LITERALS = "[^a-zA-Z0-9,\\-\\+,:]";
    private static final String PAGES_REPLACE_PATTERN = "${startpage}--${endpage}";
    private static final String SINGLE_PAGE_REPLACE_PATTERN = "$1";

    @Override
    public String getName() {
        return Localization.lang("Normalize page numbers", new String[0]);
    }

    @Override
    public String getKey() {
        return "normalize_page_numbers";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        if (value.isEmpty()) {
            return value;
        }
        String cleanValue = value.replace("pp.", "").replace("p.", "");
        Matcher matcher = PAGES_DETECT_PATTERN.matcher(cleanValue = cleanValue.replaceAll("\u2013|\u2014", "-").replaceAll(REJECT_LITERALS, ""));
        if (matcher.matches()) {
            if (Strings.isNullOrEmpty(matcher.group("endpage"))) {
                return matcher.replaceFirst(SINGLE_PAGE_REPLACE_PATTERN);
            }
            return matcher.replaceFirst(PAGES_REPLACE_PATTERN);
        }
        return value;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Normalize pages to BibTeX standard.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "1 - 2";
    }
}

