/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;

public class INSPIREBibtexFilterReader
extends FilterReader {
    private static final Pattern PATTERN = Pattern.compile("@Article\\{.*,");
    private final BufferedReader inReader;
    private String line;
    private int pos;
    private boolean pre;

    public INSPIREBibtexFilterReader(Reader initialReader) {
        super(initialReader);
        this.inReader = new BufferedReader(initialReader);
        this.pos = -1;
        this.pre = false;
    }

    private String readpreLine() throws IOException {
        String l;
        do {
            if ((l = this.inReader.readLine()) == null) {
                return null;
            }
            if (l.contains("<pre>")) {
                this.pre = true;
                l = this.inReader.readLine();
            }
            if (l == null) {
                return null;
            }
            if (!l.contains("</pre>")) continue;
            this.pre = false;
        } while (!this.pre);
        return l;
    }

    private String fixBibkey(String preliminaryLine) {
        if (preliminaryLine == null) {
            return null;
        }
        if (PATTERN.matcher(preliminaryLine).find()) {
            return preliminaryLine.replace(' ', '_');
        }
        return preliminaryLine;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < 0) {
            this.line = this.fixBibkey(this.readpreLine());
            this.pos = 0;
            if (this.line == null) {
                return -1;
            }
        }
        if (this.pos >= this.line.length()) {
            this.pos = -1;
            return 10;
        }
        return this.line.charAt(this.pos++);
    }
}

