/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;

public class BibtexKeyChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> author = entry.getField("author");
        Optional<String> title = entry.getField("title");
        Optional<String> year = entry.getField("year");
        if (!(author.isPresent() && title.isPresent() && year.isPresent())) {
            return Collections.emptyList();
        }
        if (StringUtil.isBlank(entry.getCiteKeyOptional())) {
            String authorTitleYear = entry.getAuthorTitleYear(100);
            return Collections.singletonList(new IntegrityMessage(Localization.lang("empty BibTeX key", new String[0]) + ": " + authorTitleYear, entry, "bibtexkey"));
        }
        return Collections.emptyList();
    }
}

