/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Objects;
import org.jabref.model.entry.BibEntry;

public final class IntegrityMessage
implements Cloneable {
    private final BibEntry entry;
    private final String fieldName;
    private final String message;

    public IntegrityMessage(String message, BibEntry entry, String fieldName) {
        this.message = message;
        this.entry = entry;
        this.fieldName = fieldName;
    }

    public String toString() {
        return "[" + this.getEntry().getCiteKeyOptional().orElse("") + "] in " + this.getFieldName() + ": " + this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object clone() {
        return new IntegrityMessage(this.message, this.entry, this.fieldName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrityMessage that = (IntegrityMessage)o;
        return Objects.equals(this.entry, that.entry) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.fieldName, this.message);
    }
}

