/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.strings.StringUtil;

public class TitleChecker
implements ValueChecker {
    private static final Pattern INSIDE_CURLY_BRAKETS = Pattern.compile("\\{[^}\\{]*\\}");
    private static final Predicate<String> HAS_CAPITAL_LETTERS = Pattern.compile("[\\p{Lu}\\p{Lt}]").asPredicate();
    private final BibDatabaseContext databaseContext;

    public TitleChecker(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
    }

    @Override
    public Optional<String> checkValue(String value) {
        Matcher matcher;
        String valueIgnoringFirstLetter;
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        if (this.databaseContext.isBiblatexMode()) {
            return Optional.empty();
        }
        String valueTrimmed = value.trim();
        String valueOnlySpacesWithinCurlyBraces = valueIgnoringFirstLetter = valueTrimmed.startsWith("{") ? valueTrimmed : valueTrimmed.substring(1);
        while ((matcher = INSIDE_CURLY_BRAKETS.matcher(valueOnlySpacesWithinCurlyBraces)).find()) {
            valueOnlySpacesWithinCurlyBraces = matcher.replaceAll("");
        }
        boolean hasCapitalLettersThatBibtexWillConvertToSmallerOnes = HAS_CAPITAL_LETTERS.test(valueOnlySpacesWithinCurlyBraces);
        if (hasCapitalLettersThatBibtexWillConvertToSmallerOnes) {
            return Optional.of(Localization.lang("capital letters are not masked using curly brackets {}", new String[0]));
        }
        return Optional.empty();
    }
}

