/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.logic.layout.ParamLayoutFormatter;
import org.jabref.logic.layout.format.FileLinkPreferences;
import org.jabref.model.entry.FileFieldParser;
import org.jabref.model.entry.LinkedFile;

public class FileLink
implements ParamLayoutFormatter {
    private final FileLinkPreferences prefs;
    private String fileType;

    public FileLink(FileLinkPreferences fileLinkPreferences) {
        this.prefs = fileLinkPreferences;
    }

    @Override
    public String format(String field2) {
        LinkedFile link;
        block4: {
            List<LinkedFile> fileList;
            block3: {
                if (field2 == null) {
                    return "";
                }
                fileList = FileFieldParser.parse(field2);
                link = null;
                if (this.fileType != null) break block3;
                if (fileList.isEmpty()) break block4;
                link = fileList.get(0);
                break block4;
            }
            for (LinkedFile flEntry : fileList) {
                if (!flEntry.getFileType().equalsIgnoreCase(this.fileType)) continue;
                link = flEntry;
                break;
            }
        }
        if (link == null) {
            return "";
        }
        List<String> dirs = this.prefs.getFileDirForDatabase() == null ? this.prefs.getGeneratedDirForDatabase() : this.prefs.getFileDirForDatabase();
        return link.findIn(dirs.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList())).map(path -> path.normalize().toString()).orElse(link.getLink());
    }

    @Override
    public void setArgument(String arg) {
        this.fileType = arg;
    }
}

