/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedLock {
    public static final long LOCKFILE_CRITICAL_AGE = 60000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedLock.class);
    private static final String LOCKFILE_SUFFIX = ".lock";
    private static final int AQUIRE_LOCK_RETRY = 10;

    private FileBasedLock() {
    }

    private static boolean waitForFileLock(Path file, int maxWaitCount) {
        int lockCheckCount = 0;
        while (FileBasedLock.hasLockFile(file)) {
            if (lockCheckCount++ == maxWaitCount) {
                return false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static boolean waitForFileLock(Path file) {
        return FileBasedLock.waitForFileLock(file, 10);
    }

    public static boolean hasLockFile(Path file) {
        Path lockFile = FileBasedLock.getLockFilePath(file);
        return Files.exists(lockFile, new LinkOption[0]);
    }

    public static Optional<FileTime> getLockFileTimeStamp(Path file) {
        Path lockFile = FileBasedLock.getLockFilePath(file);
        try {
            return Files.exists(lockFile, new LinkOption[0]) ? Optional.of(Files.readAttributes(lockFile, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime()) : Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static boolean deleteLockFile(Path file) {
        Path lockFile = FileBasedLock.getLockFilePath(file);
        if (!Files.exists(lockFile, new LinkOption[0])) {
            return false;
        }
        try {
            Files.delete(lockFile);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete lock file", e);
        }
        return true;
    }

    public static boolean createLockFile(Path file) throws IOException {
        Path lockFile = FileBasedLock.getLockFilePath(file);
        if (Files.exists(lockFile, new LinkOption[0])) {
            return true;
        }
        try {
            Files.write(lockFile, "0".getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            LOGGER.error("Error when creating lock file.", ex);
        }
        lockFile.toFile().deleteOnExit();
        return false;
    }

    private static Path getLockFilePath(Path file) {
        return file.resolveSibling(file.getFileName() + LOCKFILE_SUFFIX);
    }
}

