/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.migrations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import org.jabref.Globals;
import org.jabref.JabRefMain;
import org.jabref.logic.util.OS;
import org.jabref.migrations.CustomEntryTypePreferenceMigration;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesMigrations {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesMigrations.class);

    private PreferencesMigrations() {
    }

    public static void runMigrations() {
        PreferencesMigrations.upgradePrefsToOrgJabRef();
        PreferencesMigrations.upgradeSortOrder();
        PreferencesMigrations.upgradeFaultyEncodingStrings();
        PreferencesMigrations.upgradeLabelPatternToBibtexKeyPattern();
        PreferencesMigrations.upgradeImportFileAndDirePatterns();
        PreferencesMigrations.upgradeStoredCustomEntryTypes();
        PreferencesMigrations.upgradeKeyBindingsToJavaFX();
        PreferencesMigrations.addCrossRefRelatedFieldsForAutoComplete();
        PreferencesMigrations.upgradeObsoleteLookAndFeels();
    }

    private static void upgradePrefsToOrgJabRef() {
        JabRefPreferences prefs = Globals.prefs;
        Preferences mainPrefsNode = Preferences.userNodeForPackage(JabRefMain.class);
        try {
            if (mainPrefsNode.childrenNames().length != 0) {
                LOGGER.debug("New prefs node already exists with content - skipping migration");
            } else if (mainPrefsNode.parent().parent().nodeExists("net/sf/jabref")) {
                LOGGER.info("Migrating old preferences.");
                Preferences oldNode = mainPrefsNode.parent().parent().node("net/sf/jabref");
                PreferencesMigrations.copyPrefsRecursively(oldNode, mainPrefsNode);
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.error("Migrating old preferences failed.", ex);
        }
    }

    private static void copyPrefsRecursively(Preferences from, Preferences to) throws BackingStoreException {
        for (String key : from.keys()) {
            String newValue = from.get(key, "");
            if (newValue.contains("net.sf")) {
                newValue = newValue.replaceAll("net\\.sf", "org");
            }
            to.put(key, newValue);
        }
        for (String child : from.childrenNames()) {
            Preferences childNode = from.node(child);
            Preferences newChildNode = to.node(child);
            PreferencesMigrations.copyPrefsRecursively(childNode, newChildNode);
        }
    }

    private static void upgradeFaultyEncodingStrings() {
        JabRefPreferences prefs = Globals.prefs;
        String defaultEncoding = prefs.get("defaultEncoding");
        if (defaultEncoding == null) {
            return;
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("UTF8", "UTF-8");
        encodingMap.put("Cp1250", "CP1250");
        encodingMap.put("Cp1251", "CP1251");
        encodingMap.put("Cp1252", "CP1252");
        encodingMap.put("Cp1253", "CP1253");
        encodingMap.put("Cp1254", "CP1254");
        encodingMap.put("Cp1257", "CP1257");
        encodingMap.put("ISO8859_1", "ISO8859-1");
        encodingMap.put("ISO8859_2", "ISO8859-2");
        encodingMap.put("ISO8859_3", "ISO8859-3");
        encodingMap.put("ISO8859_4", "ISO8859-4");
        encodingMap.put("ISO8859_5", "ISO8859-5");
        encodingMap.put("ISO8859_6", "ISO8859-6");
        encodingMap.put("ISO8859_7", "ISO8859-7");
        encodingMap.put("ISO8859_8", "ISO8859-8");
        encodingMap.put("ISO8859_9", "ISO8859-9");
        encodingMap.put("ISO8859_13", "ISO8859-13");
        encodingMap.put("ISO8859_15", "ISO8859-15");
        encodingMap.put("KOI8_R", "KOI8-R");
        encodingMap.put("Big5_HKSCS", "Big5-HKSCS");
        encodingMap.put("EUC_JP", "EUC-JP");
        if (encodingMap.containsKey(defaultEncoding)) {
            prefs.put("defaultEncoding", (String)encodingMap.get(defaultEncoding));
        }
    }

    private static void upgradeSortOrder() {
        JabRefPreferences prefs = Globals.prefs;
        if (prefs.get("exportInSpecifiedOrder", null) == null) {
            if (prefs.getBoolean("exportInStandardOrder", false)) {
                prefs.putBoolean("exportInSpecifiedOrder", true);
                prefs.put("exportPriSort", "author");
                prefs.put("exportSecSort", "editor");
                prefs.put("exportTerSort", "year");
                prefs.putBoolean("exportPriDescending", false);
                prefs.putBoolean("exportSecDescending", false);
                prefs.putBoolean("exportTerDescending", false);
            } else if (prefs.getBoolean("exportInTitleOrder", false)) {
                prefs.putBoolean("exportInSpecifiedOrder", true);
                prefs.put("exportPriSort", "title");
                prefs.put("exportSecSort", "author");
                prefs.put("exportTerSort", "editor");
                prefs.putBoolean("exportPriDescending", false);
                prefs.putBoolean("exportSecDescending", false);
                prefs.putBoolean("exportTerDescending", false);
            }
        }
    }

    private static void upgradeStoredCustomEntryTypes() {
        JabRefPreferences prefs = Globals.prefs;
        Preferences mainPrefsNode = Preferences.userNodeForPackage(JabRefMain.class);
        try {
            if (!mainPrefsNode.nodeExists("customizedBibtexTypes") && !mainPrefsNode.nodeExists("customizedBiblatexTypes")) {
                LOGGER.info("Migrating old custom entry types.");
                CustomEntryTypePreferenceMigration.upgradeStoredCustomEntryTypes(prefs.getDefaultBibDatabaseMode());
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.error("Migrating old custom entry types failed.", ex);
        }
    }

    private static void upgradeLabelPatternToBibtexKeyPattern() {
        JabRefPreferences prefs = Globals.prefs;
        try {
            String oldDefault;
            Preferences mainPrefsNode = Preferences.userNodeForPackage(JabRefMain.class);
            if (mainPrefsNode.get("defaultBibtexKeyPattern", null) == null && (oldDefault = mainPrefsNode.get("defaultLabelPattern", null)) != null) {
                prefs.put("defaultBibtexKeyPattern", oldDefault);
                LOGGER.info("Upgraded old default key generator pattern '" + oldDefault + "' to new version.");
            }
            if (mainPrefsNode.nodeExists("bibtexkeypatterns")) {
                return;
            }
            if (mainPrefsNode.nodeExists("logic/labelpattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("logic/labelpattern"));
            } else if (mainPrefsNode.nodeExists("logic/labelPattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("logic/labelPattern"));
            } else if (mainPrefsNode.nodeExists("labelPattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("labelPattern"));
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Migrating old bibtexKeyPatterns failed.", e);
        }
    }

    private static void migrateFileImportPattern(String oldStylePattern, String newStylePattern, JabRefPreferences prefs, Preferences mainPrefsNode) {
        String preferenceFileNamePattern = mainPrefsNode.get("importFileNamePattern", null);
        if (preferenceFileNamePattern != null && oldStylePattern.equals(preferenceFileNamePattern)) {
            String fileNamePattern;
            mainPrefsNode.put("importFileNamePattern", newStylePattern);
            LOGGER.info("migrated old style importFileNamePattern value \"" + oldStylePattern + "\" to new value \"" + newStylePattern + "\" in the preference file");
            if (prefs.hasKey("importFileNamePattern") && oldStylePattern.equals(fileNamePattern = prefs.get("importFileNamePattern"))) {
                prefs.put("importFileNamePattern", newStylePattern);
                LOGGER.info("migrated old style importFileNamePattern value \"" + oldStylePattern + "\" to new value \"" + newStylePattern + "\" in the running application");
            }
        }
    }

    static void upgradeImportFileAndDirePatterns() {
        JabRefPreferences prefs = Globals.prefs;
        Preferences mainPrefsNode = Preferences.userNodeForPackage(JabRefMain.class);
        if (mainPrefsNode.get("importFileNamePattern", null) != null) {
            String[] oldStylePatterns = new String[]{"\\bibtexkey", "\\bibtexkey\\begin{title} - \\format[RemoveBrackets]{\\title}\\end{title}"};
            String[] newStylePatterns = new String[]{"[bibtexkey]", "[bibtexkey] - [fulltitle]"};
            for (int i = 0; i < oldStylePatterns.length; ++i) {
                PreferencesMigrations.migrateFileImportPattern(oldStylePatterns[i], newStylePatterns[i], prefs, mainPrefsNode);
            }
        }
    }

    private static void upgradeKeyBindingsToJavaFX() {
        UnaryOperator replaceKeys = str -> {
            String result = str.replace("ctrl ", "ctrl+");
            result = result.replace("shift ", "shift+");
            result = result.replace("alt ", "alt+");
            result = result.replace("meta ", "meta+");
            return result;
        };
        JabRefPreferences prefs = Globals.prefs;
        List<String> keys = prefs.getStringList("bindings");
        keys.replaceAll(replaceKeys);
        prefs.putStringList("bindings", keys);
    }

    private static void addCrossRefRelatedFieldsForAutoComplete() {
        JabRefPreferences prefs = Globals.prefs;
        LinkedHashSet<String> keys = new LinkedHashSet<String>(prefs.getStringList("autoCompleteFields"));
        keys.add("crossref");
        keys.add("related");
        keys.add("entryset");
        prefs.putStringList("autoCompleteFields", new ArrayList<String>(keys));
    }

    private static void migrateTypedKeyPrefs(JabRefPreferences prefs, Preferences oldPatternPrefs) throws BackingStoreException {
        LOGGER.info("Found old Bibtex Key patterns which will be migrated to new version.");
        GlobalBibtexKeyPattern keyPattern = GlobalBibtexKeyPattern.fromPattern(prefs.get("defaultBibtexKeyPattern"));
        for (String key : oldPatternPrefs.keys()) {
            keyPattern.addBibtexKeyPattern(key, oldPatternPrefs.get(key, null));
        }
        prefs.putKeyPattern(keyPattern);
    }

    private static void upgradeObsoleteLookAndFeels() {
        JabRefPreferences prefs = Globals.prefs;
        String currentLandF = prefs.get("lookAndFeel");
        Stream.of("com.jgoodies.looks.windows.WindowsLookAndFeel", "com.jgoodies.looks.plastic.PlasticLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel").filter(style -> style.equals(currentLandF)).findAny().ifPresent(loolAndFeel -> {
            if (OS.WINDOWS) {
                String windowsLandF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                prefs.put("lookAndFeel", windowsLandF);
                LOGGER.info("Switched from obsolete look and feel " + currentLandF + " to " + windowsLandF);
            } else {
                String nimbusLandF = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                prefs.put("lookAndFeel", nimbusLandF);
                LOGGER.info("Switched from obsolete look and feel " + currentLandF + " to " + nimbusLandF);
            }
        });
    }
}

