/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.Objects;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.search.GroupSearchQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchGroup
extends AbstractGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchGroup.class);
    private final GroupSearchQuery query;

    public SearchGroup(String name, GroupHierarchyType context, String searchExpression, boolean caseSensitive, boolean isRegEx) {
        super(name, context);
        this.query = new GroupSearchQuery(searchExpression, caseSensitive, isRegEx);
    }

    public String getSearchExpression() {
        return this.query.getSearchExpression();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchGroup)) {
            return false;
        }
        SearchGroup other = (SearchGroup)o;
        return this.getName().equals(other.getName()) && this.getSearchExpression().equals(other.getSearchExpression()) && this.isCaseSensitive() == other.isCaseSensitive() && this.isRegularExpression() == other.isRegularExpression() && this.getHierarchicalContext() == other.getHierarchicalContext();
    }

    @Override
    public boolean contains(BibEntry entry) {
        return this.query.isMatch(entry);
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new SearchGroup(this.getName(), this.getHierarchicalContext(), this.getSearchExpression(), this.isCaseSensitive(), this.isRegularExpression());
        }
        catch (Throwable t) {
            LOGGER.error("Internal error in SearchGroup.deepCopy(). Please report this on https://github.com/JabRef/jabref/issues", t);
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.query.isCaseSensitive();
    }

    public boolean isRegularExpression() {
        return this.query.isRegularExpression();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getHierarchicalContext(), this.getSearchExpression(), this.isCaseSensitive(), this.isRegularExpression()});
    }
}

