/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomExportList {
    private static final int EXPORTER_NAME_INDEX = 0;
    private static final int EXPORTER_FILENAME_INDEX = 1;
    private static final int EXPORTER_EXTENSION_INDEX = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomExportList.class);
    private final EventList<List<String>> list;
    private final SortedList<List<String>> sorted;
    private final Map<String, TemplateExporter> formats = new TreeMap<String, TemplateExporter>();

    public CustomExportList(Comparator<List<String>> comp) {
        this.list = new BasicEventList<List<String>>();
        this.sorted = new SortedList<List<String>>(this.list, comp);
    }

    public int size() {
        return this.list.size();
    }

    public EventList<List<String>> getSortedList() {
        return this.sorted;
    }

    public Map<String, TemplateExporter> getCustomExportFormats(JabRefPreferences prefs, JournalAbbreviationLoader loader) {
        Objects.requireNonNull(prefs);
        Objects.requireNonNull(loader);
        this.formats.clear();
        this.readPrefs(prefs, loader);
        return this.formats;
    }

    private void readPrefs(JabRefPreferences prefs, JournalAbbreviationLoader loader) {
        List<String> s2;
        Objects.requireNonNull(prefs);
        Objects.requireNonNull(loader);
        this.formats.clear();
        this.list.clear();
        int i = 0;
        LayoutFormatterPreferences layoutPreferences = prefs.getLayoutFormatterPreferences(loader);
        SavePreferences savePreferences = prefs.loadForExportFromPreferences();
        while (!(s2 = prefs.getStringList("customExportFormat" + i)).isEmpty()) {
            Optional<TemplateExporter> format = this.createFormat(s2.get(0), s2.get(1), s2.get(2), layoutPreferences, savePreferences);
            if (format.isPresent()) {
                this.formats.put(format.get().getId(), format.get());
                this.list.add(s2);
            } else {
                String customExportFormat = prefs.get("customExportFormat" + i);
                LOGGER.error("Error initializing custom export format from string " + customExportFormat);
            }
            ++i;
        }
    }

    private Optional<TemplateExporter> createFormat(String exporterName, String filename, String extension, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        String lfFileName = filename.endsWith(".layout") ? filename.substring(0, filename.length() - ".layout".length()) : filename;
        if (extension.contains(".")) {
            extension = extension.substring(extension.indexOf(46) + 1, extension.length());
        }
        FileType fileType = StandardFileType.newFileType(extension);
        TemplateExporter format = new TemplateExporter(exporterName, exporterName, lfFileName, null, fileType, layoutPreferences, savePreferences);
        format.setCustomExport(true);
        return Optional.of(format);
    }

    public void store(JabRefPreferences prefs) {
        if (this.list.isEmpty()) {
            this.purge(0, prefs);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                prefs.putStringList("customExportFormat" + i, (List)this.list.get(i));
            }
            this.purge(this.list.size(), prefs);
        }
    }

    private void purge(int from, JabRefPreferences prefs) {
        int i = from;
        while (!prefs.getStringList("customExportFormat" + i).isEmpty()) {
            prefs.remove("customExportFormat" + i);
            ++i;
        }
    }

    public void remove(List<String> toRemove, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        this.createFormat(toRemove.get(0), toRemove.get(1), toRemove.get(2), layoutPreferences, savePreferences).ifPresent(format -> {
            this.formats.remove(format.getId());
            this.list.remove(toRemove);
        });
    }

    public void addFormat(String name, String layoutFile, String extension, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        this.createFormat(name, layoutFile, extension, layoutPreferences, savePreferences).ifPresent(format -> {
            this.formats.put(format.getId(), (TemplateExporter)format);
            this.list.add(Arrays.asList(name, layoutFile, extension));
        });
    }
}

