/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.util.List;
import java.util.TreeSet;
import org.jabref.Globals;
import org.jabref.logic.importer.fileformat.CustomImporter;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomImportList
extends TreeSet<CustomImporter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomImportList.class);
    private final JabRefPreferences prefs;

    public CustomImportList(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.readPrefs();
    }

    private void readPrefs() {
        List<String> s2;
        int i = 0;
        while (!(s2 = this.prefs.getStringList("customImportFormat" + i)).isEmpty()) {
            try {
                if (s2.size() == 2) {
                    super.add(new CustomImporter(s2.get(0), s2.get(1)));
                } else {
                    super.add(new CustomImporter(s2.get(3), s2.get(2)));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not load " + s2.get(0) + " from preferences. Will ignore.", e);
            }
            ++i;
        }
    }

    private void addImporter(CustomImporter customImporter) {
        super.add(customImporter);
    }

    public boolean replaceImporter(CustomImporter customImporter) {
        boolean wasContained = this.remove(customImporter);
        this.addImporter(customImporter);
        return wasContained;
    }

    public void store() {
        this.purgeAll();
        CustomImporter[] importers = this.toArray(new CustomImporter[this.size()]);
        for (int i = 0; i < importers.length; ++i) {
            Globals.prefs.putStringList("customImportFormat" + i, importers[i].getAsStringList());
        }
    }

    private void purgeAll() {
        int i = 0;
        while (!Globals.prefs.getStringList("customImportFormat" + i).isEmpty()) {
            Globals.prefs.remove("customImportFormat" + i);
            ++i;
        }
    }
}

