/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ListChangeListener;
import org.reactfx.collection.ListModificationSequence;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListChangeImpl;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.QuasiListModificationImpl;
import org.reactfx.util.Lists;

public final class ListChangeAccumulator<E>
implements ListModificationSequence<E> {
    private QuasiListChangeImpl<E> modifications = new QuasiListChangeImpl();

    public ListChangeAccumulator() {
    }

    public ListChangeAccumulator(QuasiListChange<E> change) {
        this.modifications = new QuasiListChangeImpl<E>(change);
    }

    @Override
    public ListChangeAccumulator<E> asListChangeAccumulator() {
        return this;
    }

    @Override
    public QuasiListChange<E> asListChange() {
        return this.fetch();
    }

    @Override
    public List<QuasiListModification<? extends E>> getModifications() {
        return Collections.unmodifiableList(this.modifications);
    }

    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    public QuasiListChange<E> fetch() {
        QuasiListChangeImpl<E> res = this.modifications;
        this.modifications = new QuasiListChangeImpl();
        return res;
    }

    public ListChangeAccumulator<E> drop(int n) {
        this.modifications.subList(0, n).clear();
        return this;
    }

    public ListChangeAccumulator<E> add(QuasiListModification<? extends E> mod) {
        if (this.modifications.isEmpty()) {
            this.modifications.add(mod);
        } else {
            int lastOverlapping;
            int firstOverlapping;
            int from = mod.getFrom();
            int to = from + mod.getRemovedSize();
            for (firstOverlapping = 0; firstOverlapping < this.modifications.size() && ((QuasiListModification)this.modifications.get(firstOverlapping)).getTo() < from; ++firstOverlapping) {
            }
            for (lastOverlapping = this.modifications.size() - 1; lastOverlapping >= 0 && ((QuasiListModification)this.modifications.get(lastOverlapping)).getFrom() > to; --lastOverlapping) {
            }
            int diff = mod.getTo() - mod.getFrom() - mod.getRemovedSize();
            this.offsetPendingModifications(lastOverlapping + 1, diff);
            if (lastOverlapping < firstOverlapping) {
                this.modifications.add(firstOverlapping, mod);
            } else {
                List<QuasiListModification<E>> overlapping = this.modifications.subList(firstOverlapping, lastOverlapping + 1);
                QuasiListModification<? extends E> joined = ListChangeAccumulator.join(overlapping, mod.getRemoved(), mod.getFrom());
                QuasiListModification<? extends E> newMod = ListChangeAccumulator.combine(joined, mod);
                overlapping.clear();
                this.modifications.add(firstOverlapping, newMod);
            }
        }
        return this;
    }

    public ListChangeAccumulator<E> add(QuasiListChange<? extends E> change) {
        for (QuasiListModification quasiListModification : change) {
            this.add(quasiListModification);
        }
        return this;
    }

    public ListChangeAccumulator<E> add(ListChangeListener.Change<? extends E> change) {
        while (change.next()) {
            this.add(QuasiListModification.fromCurrentStateOf(change));
        }
        return this;
    }

    private void offsetPendingModifications(int from, int offset) {
        this.modifications.subList(from, this.modifications.size()).replaceAll(mod -> new QuasiListModificationImpl(mod.getFrom() + offset, mod.getRemoved(), mod.getAddedSize()));
    }

    private static <E> QuasiListModification<? extends E> join(List<QuasiListModification<? extends E>> mods, List<? extends E> gone, int goneOffset) {
        if (mods.size() == 1) {
            return mods.get(0);
        }
        ArrayList removedLists = new ArrayList(2 * mods.size() - 1);
        QuasiListModification<E> prev = mods.get(0);
        int from = prev.getFrom();
        removedLists.add(prev.getRemoved());
        for (int i = 1; i < mods.size(); ++i) {
            QuasiListModification<E> m3 = mods.get(i);
            removedLists.add(gone.subList(prev.getTo() - goneOffset, m3.getFrom() - goneOffset));
            removedLists.add(m3.getRemoved());
            prev = m3;
        }
        List removed = Lists.concat(removedLists);
        return new QuasiListModificationImpl(from, removed, prev.getTo() - from);
    }

    private static <E> QuasiListModification<E> combine(QuasiListModification<? extends E> former, QuasiListModification<? extends E> latter) {
        if (latter.getFrom() >= former.getFrom() && latter.getFrom() + latter.getRemovedSize() <= former.getTo()) {
            List removed = former.getRemoved();
            int addedSize = former.getAddedSize() - latter.getRemovedSize() + latter.getAddedSize();
            return new QuasiListModificationImpl(former.getFrom(), removed, addedSize);
        }
        if (latter.getFrom() <= former.getFrom() && latter.getFrom() + latter.getRemovedSize() >= former.getTo()) {
            List removed = Lists.concat(latter.getRemoved().subList(0, former.getFrom() - latter.getFrom()), former.getRemoved(), latter.getRemoved().subList(former.getTo() - latter.getFrom(), latter.getRemovedSize()));
            return new QuasiListModificationImpl(latter.getFrom(), removed, latter.getAddedSize());
        }
        if (latter.getFrom() >= former.getFrom()) {
            List removed = Lists.concat(former.getRemoved(), latter.getRemoved().subList(former.getTo() - latter.getFrom(), latter.getRemovedSize()));
            return new QuasiListModificationImpl(former.getFrom(), removed, latter.getTo() - former.getFrom());
        }
        List removed = Lists.concat(latter.getRemoved().subList(0, former.getFrom() - latter.getFrom()), former.getRemoved());
        int addedSize = former.getTo() - latter.getRemovedSize() + latter.getAddedSize() - latter.getFrom();
        return new QuasiListModificationImpl(latter.getFrom(), removed, addedSize);
    }
}

