/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.value.ValBase;
import org.reactfx.value.Var;

class SimpleVar<T>
extends ValBase<T>
implements Var<T> {
    private final InvalidationListener boundToListener = obs -> this.invalidate();
    private T value;
    private ObservableValue<? extends T> boundTo = null;

    public SimpleVar(T initialValue) {
        this.value = initialValue;
    }

    public void bind(ObservableValue<? extends T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot bind to null");
        }
        if (this.boundTo != null) {
            this.boundTo.removeListener(this.boundToListener);
        }
        this.boundTo = other;
        if (this.isObservingInputs()) {
            this.boundTo.addListener(this.boundToListener);
        }
        this.invalidate();
    }

    public void unbind() {
        if (this.boundTo != null) {
            this.boundTo.removeListener(this.boundToListener);
            this.boundTo = null;
        }
    }

    public boolean isBound() {
        return this.boundTo != null;
    }

    public void setValue(T value) {
        if (this.isBound()) {
            throw new IllegalStateException("Cannot set a bound property");
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.invalidate();
        }
    }

    @Override
    protected Subscription connect() {
        if (this.boundTo != null) {
            this.boundTo.addListener(this.boundToListener);
        }
        return () -> {
            if (this.boundTo != null) {
                this.boundTo.removeListener(this.boundToListener);
            }
        };
    }

    @Override
    protected T computeValue() {
        if (this.isBound()) {
            this.value = this.boundTo.getValue();
        }
        return this.value;
    }
}

